/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.chunk.effect;

import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.chunk.IDrainSpotEffect;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.misc.WeightedOre;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayerFactory;
import org.apache.commons.lang3.tuple.Pair;

public class OreSpawnEffect
implements IDrainSpotEffect {
    public static final Set<BlockState> SPAWN_EXCEPTIONS = new HashSet<BlockState>();
    public static final ResourceLocation NAME = new ResourceLocation("naturesaura", "ore_spawn");
    private int amount;
    private int dist;

    private boolean calcValues(Level level, BlockPos pos, Integer spot) {
        if (spot <= 0) {
            return false;
        }
        Pair<Integer, Integer> auraAndSpots = IAuraChunk.getAuraAndSpotAmountInArea(level, pos, 30);
        int aura = (Integer)auraAndSpots.getLeft();
        if (aura <= 2000000) {
            return false;
        }
        this.amount = Math.min(20, Mth.ceil((float)((float)Math.abs(aura) / 300000.0f / (float)((Integer)auraAndSpots.getRight()).intValue())));
        if (this.amount <= 0) {
            return false;
        }
        this.dist = Mth.clamp((int)(Math.abs(aura) / 150000), (int)5, (int)20);
        return true;
    }

    @Override
    public IDrainSpotEffect.ActiveType isActiveHere(Player player, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot) {
        if (!this.calcValues(player.level(), pos, spot)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (player.distanceToSqr((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()) > (double)(this.dist * this.dist)) {
            return IDrainSpotEffect.ActiveType.INACTIVE;
        }
        if (!NaturesAuraAPI.instance().isEffectPowderActive(player.level(), player.blockPosition(), NAME)) {
            return IDrainSpotEffect.ActiveType.INHIBITED;
        }
        return IDrainSpotEffect.ActiveType.ACTIVE;
    }

    @Override
    public ItemStack getDisplayIcon() {
        return new ItemStack((ItemLike)Blocks.DIAMOND_ORE);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void update(Level level, LevelChunk chunk, IAuraChunk auraChunk, BlockPos pos, Integer spot, AuraChunk.DrainSpot actualSpot) {
        if (level.getGameTime() % 40L != 0L) {
            return;
        }
        if (!this.calcValues(level, pos, spot)) {
            return;
        }
        type = auraChunk.getType();
        if (type.isSimilar(NaturesAuraAPI.TYPE_OVERWORLD)) {
            requiredBlock = Blocks.STONE;
            ores = NaturesAuraAPI.OVERWORLD_ORES;
        } else {
            requiredBlock = Blocks.NETHERRACK;
            ores = NaturesAuraAPI.NETHER_ORES;
        }
        totalWeight = WeightedRandom.getTotalWeight(ores);
        powders = NaturesAuraAPI.instance().getActiveEffectPowders(level, new AABB(pos).inflate((double)this.dist), OreSpawnEffect.NAME);
        if (powders.isEmpty()) {
            return;
        }
        for (i = 0; i < this.amount; ++i) {
            powder = powders.get(i % powders.size());
            powderPos = (Vec3)powder.getA();
            range = (Integer)powder.getB();
            x = Mth.floor((double)(powderPos.x + level.random.nextGaussian() * (double)range));
            orePos = new BlockPos(x, y = Mth.floor((double)(powderPos.y + level.random.nextGaussian() * (double)range)), z = Mth.floor((double)(powderPos.z + level.random.nextGaussian() * (double)range)));
            if (!(orePos.distToCenterSqr(powderPos.x, powderPos.y, powderPos.z) <= (double)(range * range)) || !(orePos.distSqr((Vec3i)pos) <= (double)(this.dist * this.dist)) || !level.isLoaded(orePos) || (state = level.getBlockState(orePos)).getBlock() != requiredBlock) continue;
            block1: while (true) {
                if ((ore = (WeightedOre)WeightedRandom.getRandomItem((RandomSource)level.random, ores, (int)totalWeight).orElse(null)) == null || (tag = TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)ore.tag)) == null) {
                    continue;
                }
                var23_23 = ((HolderSet.Named)BuiltInRegistries.BLOCK.getTag(tag).orElseThrow()).iterator();
                while (true) {
                    if (var23_23.hasNext()) ** break;
                    continue block1;
                    toPlaceHolder = (Holder)var23_23.next();
                    if (toPlaceHolder == null || (toPlace = (Block)toPlaceHolder.value()) == Blocks.AIR) continue;
                    player = FakePlayerFactory.getMinecraft((ServerLevel)((ServerLevel)level));
                    player.setItemInHand(InteractionHand.MAIN_HAND, ItemStack.EMPTY);
                    ray = new BlockHitResult(Vec3.atCenterOf((Vec3i)pos), Direction.UP, pos, false);
                    context = new BlockPlaceContext(new UseOnContext((Player)player, InteractionHand.MAIN_HAND, ray));
                    stateToPlace = toPlace.getStateForPlacement(context);
                    if (!OreSpawnEffect.SPAWN_EXCEPTIONS.contains(stateToPlace)) break block1;
                }
                break;
            }
            level.setBlockAndUpdate(orePos, stateToPlace);
            level.levelEvent(2001, orePos, Block.getId((BlockState)stateToPlace));
            toDrain = (20000 - ore.getWeight().asInt() * 2) * 2;
            highestSpot = IAuraChunk.getHighestSpot(level, orePos, 30, pos);
            IAuraChunk.getAuraChunk(level, highestSpot).drainAura(highestSpot, toDrain);
        }
    }

    @Override
    public boolean appliesHere(LevelChunk chunk, IAuraChunk auraChunk, IAuraType type) {
        return (Boolean)ModConfig.instance.oreEffect.get() != false && (type.isSimilar(NaturesAuraAPI.TYPE_OVERWORLD) || type.isSimilar(NaturesAuraAPI.TYPE_NETHER));
    }

    @Override
    public ResourceLocation getName() {
        return NAME;
    }
}

