/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat;

import com.google.common.collect.ImmutableMap;
import de.ellpeck.naturesaura.compat.ICompat;
import de.ellpeck.naturesaura.data.ItemTagProvider;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.CuriosDataProvider;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class CuriosCompat
implements ICompat {
    private static final Map<Item, String> TYPES = ImmutableMap.builder().put((Object)ModItems.EYE, (Object)"charm").put((Object)ModItems.EYE_IMPROVED, (Object)"charm").put((Object)ModItems.AURA_CACHE, (Object)"belt").put((Object)ModItems.AURA_TROVE, (Object)"belt").put((Object)ModItems.SHOCKWAVE_CREATOR, (Object)"necklace").put((Object)ModItems.DEATH_RING, (Object)"ring").build();

    @Override
    public void addCapabilities(RegisterCapabilitiesEvent event) {
        for (Item item : TYPES.keySet()) {
            event.registerItem(CuriosCapability.ITEM, (s, c) -> new ICurio(){
                final /* synthetic */ ItemStack val$s;
                {
                    this.val$s = itemStack;
                }

                public void curioTick(SlotContext slotContext) {
                    this.val$s.getItem().inventoryTick(this.val$s, slotContext.entity().level(), (Entity)slotContext.entity(), -1, false);
                }

                public ItemStack getStack() {
                    return this.val$s;
                }

                public boolean canEquipFromUse(SlotContext slotContext) {
                    return true;
                }

                public boolean canSync(SlotContext slotContext) {
                    return true;
                }
            }, new ItemLike[]{item});
        }
    }

    @Override
    public void gatherData(GatherDataEvent event) {
        event.getGenerator().addProvider(event.includeServer(), (DataProvider)new CuriosProvider(event.getGenerator().getPackOutput(), event.getExistingFileHelper(), event.getLookupProvider()));
    }

    @Override
    public void addItemTags(ItemTagProvider provider) {
        for (Map.Entry<Item, String> entry : TYPES.entrySet()) {
            TagKey tag = ItemTags.create((ResourceLocation)new ResourceLocation("curios", entry.getValue()));
            provider.tag((TagKey<Item>)tag).add((Object)entry.getKey());
        }
    }

    private static class CuriosProvider
    extends CuriosDataProvider {
        public CuriosProvider(PackOutput output, ExistingFileHelper fileHelper, CompletableFuture<HolderLookup.Provider> registries) {
            super("naturesaura", output, fileHelper, registries);
        }

        public void generate(HolderLookup.Provider provider, ExistingFileHelper existingFileHelper) {
            for (String type : TYPES.values()) {
                this.createSlot(type);
            }
        }
    }
}

