/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.patchouli;

import de.ellpeck.naturesaura.compat.patchouli.PatchouliCompat;
import de.ellpeck.naturesaura.recipes.AnimalSpawnerRecipe;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorAnimalSpawner
implements IComponentProcessor {
    private AnimalSpawnerRecipe recipe;

    public void setup(Level level, IVariableProvider provider) {
        this.recipe = (AnimalSpawnerRecipe)PatchouliCompat.getRecipe("animal_spawner", provider.get("recipe").asString());
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.startsWith("input")) {
            int id = Integer.parseInt(key.substring(5)) - 1;
            return this.recipe.ingredients.size() > id ? PatchouliCompat.ingredientVariable(this.recipe.ingredients.get(id)) : null;
        }
        return switch (key) {
            case "name" -> IVariable.wrap((String)this.recipe.entity.getDescription().getString());
            case "entity" -> IVariable.wrap((String)BuiltInRegistries.ENTITY_TYPE.getKey(this.recipe.entity).toString());
            case "egg" -> IVariable.from((Object)new ItemStack((ItemLike)SpawnEggItem.byId(this.recipe.entity)));
            default -> null;
        };
    }

    public boolean allowRender(String group) {
        return !"seekrit".equals(group);
    }
}

