/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.compat.patchouli;

import de.ellpeck.naturesaura.compat.patchouli.PatchouliCompat;
import de.ellpeck.naturesaura.recipes.TreeRitualRecipe;
import net.minecraft.world.level.Level;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ProcessorTreeRitual
implements IComponentProcessor {
    private TreeRitualRecipe recipe;

    public void setup(Level level, IVariableProvider provider) {
        this.recipe = (TreeRitualRecipe)PatchouliCompat.getRecipe("tree_ritual", provider.get("recipe").asString());
    }

    public IVariable process(Level level, String key) {
        if (this.recipe == null) {
            return null;
        }
        if (key.startsWith("input")) {
            int id = Integer.parseInt(key.substring(5)) - 1;
            return this.recipe.ingredients.size() > id ? PatchouliCompat.ingredientVariable(this.recipe.ingredients.get(id)) : null;
        }
        return switch (key) {
            case "output" -> IVariable.from((Object)this.recipe.output);
            case "sapling" -> PatchouliCompat.ingredientVariable(this.recipe.saplingType);
            case "name" -> IVariable.wrap((String)this.recipe.output.getHoverName().getString());
            default -> null;
        };
    }
}

