/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.data;

import de.ellpeck.naturesaura.blocks.BlockFlowerPot;
import de.ellpeck.naturesaura.blocks.BlockGoldenLeaves;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.blocks.Slab;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import java.util.Set;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.entries.LootPoolSingletonContainer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.predicates.ConditionUserBuilder;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemRandomChanceCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;

public class BlockLootProvider
extends BlockLootSubProvider {
    public BlockLootProvider() {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags());
    }

    protected void generate() {
        for (IModItem item : ModRegistry.ALL_ITEMS) {
            if (!(item instanceof Block)) continue;
            Block block = (Block)item;
            if (block instanceof Slab) {
                this.add(block, x$0 -> this.createSlabItemTable((Block)x$0));
                continue;
            }
            if (block instanceof BlockFlowerPot) {
                this.add(block, x$0 -> this.createPotFlowerItemTable((ItemLike)x$0));
                continue;
            }
            this.dropSelf(block);
        }
        this.add(ModBlocks.ANCIENT_LEAVES, x$0 -> BlockLootProvider.createSilkTouchOnlyTable((ItemLike)x$0));
        this.add(ModBlocks.DECAYED_LEAVES, x$0 -> BlockLootProvider.createSilkTouchOnlyTable((ItemLike)x$0));
        this.add(ModBlocks.GOLDEN_LEAVES, b -> LootTable.lootTable().withPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add(((LootPoolSingletonContainer.Builder)this.applyExplosionCondition((ItemLike)b, (ConditionUserBuilder)LootItem.lootTableItem((ItemLike)ModItems.GOLD_LEAF))).when((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.hasBlockStateProperties((Block)b).setProperties(StatePropertiesPredicate.Builder.properties().hasProperty((Property)BlockGoldenLeaves.STAGE, 3)))).when(LootItemRandomChanceCondition.randomChance((float)0.75f))));
        this.add(ModBlocks.NETHER_WART_MUSHROOM, b -> BlockLootSubProvider.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Items.NETHER_WART).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)1.0f, (float)2.0f)))));
        this.add(ModBlocks.NETHER_GRASS, b -> BlockLootSubProvider.createSilkTouchDispatchTable((Block)b, (LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)Blocks.NETHERRACK)));
    }

    protected Iterable<Block> getKnownBlocks() {
        return ModRegistry.ALL_ITEMS.stream().filter(i -> i instanceof Block).map(i -> (Block)i).toList();
    }
}

