/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.entities;

import com.google.common.collect.ListMultimap;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.entities.ModEntities;
import de.ellpeck.naturesaura.items.ItemEffectPowder;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.misc.LevelData;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

public class EntityEffectInhibitor
extends Entity
implements IVisualizable {
    private static final EntityDataAccessor<String> INHIBITED_EFFECT = SynchedEntityData.defineId(EntityEffectInhibitor.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityDataAccessor<Integer> COLOR = SynchedEntityData.defineId(EntityEffectInhibitor.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> AMOUNT = SynchedEntityData.defineId(EntityEffectInhibitor.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private ResourceLocation lastEffect;
    private boolean powderListDirty;
    @OnlyIn(value=Dist.CLIENT)
    public int renderTicks;

    public EntityEffectInhibitor(EntityType<?> entityTypeIn, Level levelIn) {
        super(entityTypeIn, levelIn);
    }

    public static void place(Level level, ItemStack stack, double posX, double posY, double posZ) {
        ResourceLocation effect = ItemEffectPowder.getEffect(stack);
        EntityEffectInhibitor entity = new EntityEffectInhibitor(ModEntities.EFFECT_INHIBITOR, level);
        entity.setInhibitedEffect(effect);
        entity.setColor(NaturesAuraAPI.EFFECT_POWDERS.get(effect));
        entity.setAmount(stack.getCount());
        entity.setPos(posX, posY, posZ);
        level.addFreshEntity((Entity)entity);
    }

    public void onAddedToWorld() {
        super.onAddedToWorld();
        this.powderListDirty = true;
    }

    public void onRemovedFromWorld() {
        super.onRemovedFromWorld();
        this.updatePowderListStatus(null);
    }

    protected void defineSynchedData() {
        this.entityData.define(INHIBITED_EFFECT, (Object)"");
        this.entityData.define(COLOR, (Object)0);
        this.entityData.define(AMOUNT, (Object)0);
    }

    public void onSyncedDataUpdated(EntityDataAccessor<?> key) {
        super.onSyncedDataUpdated(key);
        if (INHIBITED_EFFECT.equals(key) || AMOUNT.equals(key)) {
            this.powderListDirty = true;
        }
    }

    public void setPos(double x, double y, double z) {
        if (x != this.getX() || y != this.getY() || z != this.getZ()) {
            this.powderListDirty = true;
        }
        super.setPos(x, y, z);
    }

    public void tick() {
        super.tick();
        if (this.powderListDirty) {
            this.updatePowderListStatus(this.getInhibitedEffect());
        }
        if (this.level().isClientSide) {
            if (this.level().getGameTime() % 5L == 0L) {
                NaturesAuraAPI.instance().spawnMagicParticle(this.getX() + this.level().random.nextGaussian() * (double)0.1f, this.getY(), this.getZ() + this.level().random.nextGaussian() * (double)0.1f, this.level().random.nextGaussian() * (double)0.005f, this.level().random.nextFloat() * 0.03f, this.level().random.nextGaussian() * (double)0.005f, this.getColor(), this.level().random.nextFloat() * 3.0f + 1.0f, 120, 0.0f, true, true);
            }
            ++this.renderTicks;
        }
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.setInhibitedEffect(new ResourceLocation(compound.getString("effect")));
        this.setColor(compound.getInt("color"));
        this.setAmount(compound.contains("amount") ? compound.getInt("amount") : 24);
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putString("effect", this.getInhibitedEffect().toString());
        compound.putInt("color", this.getColor());
        compound.putInt("amount", this.getAmount());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean skipAttackInteraction(Entity entity) {
        if (!(entity instanceof Player)) return false;
        Player player = (Player)entity;
        if (!this.level().mayInteract(player, this.blockPosition())) return true;
        if (!this.hurt(this.damageSources().playerAttack(player), 0.0f)) return false;
        return true;
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.getEntity() != null && !this.level().isClientSide) {
            this.spawnAtLocation(this.getDrop(), 0.0f);
            this.kill();
            return true;
        }
        return super.hurt(source, amount);
    }

    public boolean isPickable() {
        return true;
    }

    @Nullable
    public ItemStack getPickResult() {
        return this.getDrop();
    }

    public ItemStack getDrop() {
        return ItemEffectPowder.setEffect(new ItemStack((ItemLike)ModItems.EFFECT_POWDER, this.getAmount()), this.getInhibitedEffect());
    }

    public ResourceLocation getInhibitedEffect() {
        String effect = (String)this.entityData.get(INHIBITED_EFFECT);
        if (effect == null || effect.isEmpty()) {
            return null;
        }
        return new ResourceLocation(effect);
    }

    public void setInhibitedEffect(ResourceLocation effect) {
        this.entityData.set(INHIBITED_EFFECT, (Object)(effect != null ? effect.toString() : ""));
    }

    public int getColor() {
        return (Integer)this.entityData.get(COLOR);
    }

    public void setColor(int color) {
        this.entityData.set(COLOR, (Object)color);
    }

    public int getAmount() {
        return (Integer)this.entityData.get(AMOUNT);
    }

    public void setAmount(int amount) {
        this.entityData.set(AMOUNT, (Object)amount);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public AABB getVisualizationBounds(Level level, BlockPos pos) {
        return Helper.aabb(this.getEyePosition()).inflate((double)this.getAmount());
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getVisualizationColor(Level level, BlockPos pos) {
        return this.getColor();
    }

    private void updatePowderListStatus(ResourceLocation inhibitedEffect) {
        ListMultimap<ResourceLocation, Tuple<Vec3, Integer>> powders = ((LevelData)ILevelData.getLevelData((Level)this.level())).effectPowders;
        if (this.lastEffect != null) {
            List oldList = powders.get((Object)this.lastEffect);
            oldList.removeIf(t -> this.getEyePosition().equals(t.getA()));
        }
        if (inhibitedEffect != null) {
            List newList = powders.get((Object)inhibitedEffect);
            newList.add(new Tuple((Object)this.getEyePosition(), (Object)this.getAmount()));
        }
        this.powderListDirty = false;
        this.lastEffect = inhibitedEffect;
    }
}

