/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.events;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.ModConfig;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.api.render.IVisualizable;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityAuraTimer;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityGratedChute;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityItemDistributor;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityNatureAltar;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntityRFConverter;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.items.ItemAuraCache;
import de.ellpeck.naturesaura.items.ItemRangeVisualizer;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.packet.PacketAuraChunk;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.MyceliumBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.CustomizeGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderGuiOverlayEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.gui.overlay.VanillaGuiOverlay;
import net.neoforged.neoforge.common.IPlantable;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.items.IItemHandler;
import org.apache.commons.lang3.mutable.MutableInt;

@OnlyIn(value=Dist.CLIENT)
public class ClientEvents {
    public static final ResourceLocation OVERLAYS = new ResourceLocation("naturesaura", "textures/gui/overlays.png");
    public static final ResourceLocation BOOK_GUI = new ResourceLocation("naturesaura", "textures/gui/book.png");
    public static final List<PacketAuraChunk> PENDING_AURA_CHUNKS = new ArrayList<PacketAuraChunk>();
    private static final ItemStack ITEM_FRAME = new ItemStack((ItemLike)Items.ITEM_FRAME);
    private static final ItemStack DISPENSER = new ItemStack((ItemLike)Blocks.DISPENSER);
    private static final Map<ResourceLocation, Tuple<ItemStack, Boolean>> SHOWING_EFFECTS = new HashMap<ResourceLocation, Tuple<ItemStack, Boolean>>();
    private static ItemStack heldCache = ItemStack.EMPTY;
    private static ItemStack heldEye = ItemStack.EMPTY;
    private static ItemStack heldOcular = ItemStack.EMPTY;
    private static BlockPos hoveringAuraSpot;

    @SubscribeEvent
    public void onDebugRender(CustomizeGuiOverlayEvent.DebugText event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.getDebugOverlay().showDebugScreen() && ((Boolean)ModConfig.instance.debugText.get()).booleanValue()) {
            String prefix = ChatFormatting.GREEN + "[Nature's Aura]" + ChatFormatting.RESET + " ";
            List left = event.getLeft();
            if (mc.player.isCreative() || mc.player.isSpectator()) {
                left.add("");
                MutableInt amount = new MutableInt(1000000);
                MutableInt spots = new MutableInt();
                MutableInt chunks = new MutableInt();
                IAuraChunk.getSpotsInArea((Level)mc.level, mc.player.blockPosition(), 35, (blockPos, drainSpot) -> {
                    spots.increment();
                    amount.add((Number)drainSpot);
                });
                Helper.getAuraChunksWithSpotsInArea((Level)mc.level, mc.player.blockPosition(), 35, c -> chunks.increment());
                NumberFormat format = NumberFormat.getInstance();
                left.add(prefix + "A: " + format.format(amount.intValue()) + " (S: " + spots.intValue() + ", C: " + chunks.intValue() + ")");
                left.add(prefix + "AT: " + IAuraType.forLevel((Level)mc.level).getName());
            }
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            heldCache = ItemStack.EMPTY;
            heldEye = ItemStack.EMPTY;
            heldOcular = ItemStack.EMPTY;
            Minecraft mc = Minecraft.getInstance();
            if (mc.level == null) {
                ItemRangeVisualizer.clear();
                PENDING_AURA_CHUNKS.clear();
            } else {
                PENDING_AURA_CHUNKS.removeIf(next -> next.tryHandle((Level)mc.level));
                if (!mc.isPaused()) {
                    if (mc.level.getGameTime() % 20L == 0L) {
                        int amount = Mth.floor((double)(190.0 * (Double)ModConfig.instance.excessParticleAmount.get()));
                        for (int i = 0; i < amount; ++i) {
                            int chance;
                            int excess;
                            int z;
                            int y;
                            int x = Mth.floor((double)mc.player.getX()) + mc.level.random.nextInt(64) - 32;
                            BlockPos pos = Helper.getClosestAirAboveGround((Level)mc.level, new BlockPos(x, y = Mth.floor((double)mc.player.getY()) + mc.level.random.nextInt(32) - 16, z = Mth.floor((double)mc.player.getZ()) + mc.level.random.nextInt(64) - 32), 16).below();
                            BlockState state = mc.level.getBlockState(pos);
                            Block block = state.getBlock();
                            if (!(block instanceof BonemealableBlock) && !(block instanceof IPlantable) && !(block instanceof LeavesBlock) && !(block instanceof MyceliumBlock) || (excess = IAuraChunk.triangulateAuraInArea((Level)mc.level, pos, 45) - 1000000) <= 0 || mc.level.random.nextInt(chance = Math.max(10, 50 - excess / 25000)) > 0) continue;
                            NaturesAuraAPI.instance().spawnMagicParticle((float)pos.getX() + mc.level.random.nextFloat(), (float)pos.getY() + 0.5f, (float)pos.getZ() + mc.level.random.nextFloat(), mc.level.random.nextGaussian() * (double)0.01f, mc.level.random.nextFloat() * 0.025f, mc.level.random.nextGaussian() * (double)0.01f, block instanceof MyceliumBlock ? 8871073 : BiomeColors.getAverageGrassColor((BlockAndTintGetter)mc.level, (BlockPos)pos), Math.min(2.0f, 1.0f + mc.level.random.nextFloat() * ((float)excess / 30000.0f)), Math.min(300, 100 + mc.level.random.nextInt(excess / 3000 + 1)), 0.0f, false, true);
                        }
                    }
                    if (Helper.isHoldingItem((Player)mc.player, ModItems.RANGE_VISUALIZER) && mc.level.getGameTime() % 5L == 0L) {
                        NaturesAuraAPI.IInternalHooks inst = NaturesAuraAPI.instance();
                        inst.setParticleSpawnRange(512);
                        inst.setParticleDepth(false);
                        for (BlockPos pos : ItemRangeVisualizer.VISUALIZED_RAILS.get((Object)mc.level.dimension().location())) {
                            NaturesAuraAPI.instance().spawnMagicParticle((float)pos.getX() + mc.level.random.nextFloat(), (float)pos.getY() + mc.level.random.nextFloat(), (float)pos.getZ() + mc.level.random.nextFloat(), 0.0, 0.0, 0.0, 14744319, mc.level.random.nextFloat() * 5.0f + 1.0f, 100, 0.0f, false, true);
                        }
                        inst.setParticleDepth(true);
                        inst.setParticleSpawnRange(32);
                    }
                    heldCache = Helper.getEquippedItem(s -> s.getItem() instanceof ItemAuraCache, (Player)mc.player, false);
                    heldEye = Helper.getEquippedItem(s -> s.getItem() == ModItems.EYE, (Player)mc.player, true);
                    heldOcular = Helper.getEquippedItem(s -> s.getItem() == ModItems.EYE_IMPROVED, (Player)mc.player, false);
                    if (!heldOcular.isEmpty() && mc.level.getGameTime() % 20L == 0L) {
                        SHOWING_EFFECTS.clear();
                        Helper.getAuraChunksWithSpotsInArea((Level)mc.level, mc.player.blockPosition(), 100, chunk -> chunk.getActiveEffectIcons((Player)mc.player, SHOWING_EFFECTS));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public void onLevelRender(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Vec3 view = mc.gameRenderer.getMainCamera().getPosition();
        Tesselator tesselator = Tesselator.getInstance();
        BufferBuilder buffer = tesselator.getBuilder();
        mc.getProfiler().push("naturesaura:onLevelRender");
        RenderSystem.enableDepthTest();
        PoseStack mv = RenderSystem.getModelViewStack();
        mv.pushPose();
        mv.mulPoseMatrix(event.getPoseStack().last().pose());
        mv.translate(-view.x, -view.y, -view.z);
        RenderSystem.applyModelViewMatrix();
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionColorShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        hoveringAuraSpot = null;
        if (mc.getDebugOverlay().showDebugScreen() && (mc.player.isCreative() || mc.player.isSpectator()) && ((Boolean)ModConfig.instance.debugLevel.get()).booleanValue()) {
            Vec3 playerEye = mc.player.getEyePosition(event.getPartialTick());
            Vec3 playerView = mc.player.getViewVector(event.getPartialTick()).normalize();
            float range = mc.gameMode.getPickRange();
            buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            IAuraChunk.getSpotsInArea((Level)mc.level, mc.player.blockPosition(), 64, (pos, spot) -> {
                Helper.renderWeirdBox((VertexConsumer)buffer, pos.getX(), pos.getY(), pos.getZ(), 1.0, 1.0, 1.0, spot > 0 ? 0.0f : 1.0f, spot > 0 ? 1.0f : 0.0f, 0.0f, 0.35f);
                if (playerEye.distanceToSqr((double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5) <= (double)(range * range)) {
                    for (float d = 0.0f; d <= range; d += 0.5f) {
                        if (!pos.equals((Object)BlockPos.containing((Position)playerEye.add(playerView.scale((double)d))))) continue;
                        hoveringAuraSpot = pos;
                        break;
                    }
                }
            });
            tesselator.end();
        }
        if (Helper.isHoldingItem((Player)mc.player, ModItems.RANGE_VISUALIZER)) {
            RenderSystem.disableCull();
            ResourceLocation dim = mc.level.dimension().location();
            buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
            for (BlockPos pos2 : ItemRangeVisualizer.VISUALIZED_BLOCKS.get((Object)dim)) {
                BlockState state;
                Block block;
                if (!mc.level.isLoaded(pos2) || !((block = (state = mc.level.getBlockState(pos2)).getBlock()) instanceof IVisualizable)) continue;
                this.renderVisualize(buffer, (IVisualizable)block, (Level)mc.level, pos2);
            }
            for (Entity entity : ItemRangeVisualizer.VISUALIZED_ENTITIES.get((Object)dim)) {
                if (!entity.isAlive() || !(entity instanceof IVisualizable)) continue;
                this.renderVisualize(buffer, (IVisualizable)entity, (Level)mc.level, entity.blockPosition());
            }
            tesselator.end();
            RenderSystem.enableCull();
        }
        mv.popPose();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.disableBlend();
        mc.getProfiler().pop();
    }

    private void renderVisualize(BufferBuilder buffer, IVisualizable visualize, Level level, BlockPos pos) {
        AABB box = visualize.getVisualizationBounds(level, pos);
        if (box != null) {
            box = box.inflate((double)0.05f);
            int color = visualize.getVisualizationColor(level, pos);
            Helper.renderWeirdBox((VertexConsumer)buffer, box.minX, box.minY, box.minZ, box.maxX - box.minX, box.maxY - box.minY, box.maxZ - box.minZ, (float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 0.5f);
        }
    }

    @SubscribeEvent
    public void onOverlayRender(RenderGuiOverlayEvent.Post event) {
        Minecraft mc = Minecraft.getInstance();
        GuiGraphics graphics = event.getGuiGraphics();
        PoseStack stack = graphics.pose();
        if (event.getOverlay() == VanillaGuiOverlay.HOTBAR.type()) {
            Window res = event.getWindow();
            if (mc.player != null) {
                if (!heldCache.isEmpty()) {
                    IAuraContainer container = (IAuraContainer)heldCache.getCapability(NaturesAuraAPI.AURA_CONTAINER_ITEM_CAPABILITY, null);
                    int width = Mth.ceil((float)((float)container.getStoredAura() / (float)container.getMaxAura() * 80.0f));
                    int conf = (Integer)ModConfig.instance.cacheBarLocation.get();
                    int x = res.getGuiScaledWidth() / 2 + (conf == 0 ? -173 - (mc.player.getOffhandItem().isEmpty() ? 0 : 29) : 93);
                    int y = res.getGuiScaledHeight() - 8;
                    stack.pushPose();
                    int color = container.getAuraColor();
                    graphics.setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f);
                    if (width < 80) {
                        graphics.blit(OVERLAYS, x + width, y, (float)width, 0.0f, 80 - width, 6, 256, 256);
                    }
                    if (width > 0) {
                        graphics.blit(OVERLAYS, x, y, 0.0f, 6.0f, width, 6, 256, 256);
                    }
                    float scale = 0.75f;
                    stack.pushPose();
                    stack.scale(scale, scale, scale);
                    String s = heldCache.getHoverName().getString();
                    graphics.drawString(mc.font, s, conf == 1 ? (float)x / scale : (float)(x + 80) / scale - (float)mc.font.width(s), (float)(y - 7) / scale, color, true);
                    stack.popPose();
                    graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                    stack.pushPose();
                }
                if (!heldEye.isEmpty() || !heldOcular.isEmpty()) {
                    BlockHitResult blockHitResult;
                    BlockPos pos;
                    HitResult totalAmount2;
                    stack.pushPose();
                    int conf = (Integer)ModConfig.instance.auraBarLocation.get();
                    if (!(mc.getDebugOverlay().showDebugScreen() || conf == 2 && mc.screen instanceof ChatScreen)) {
                        int y;
                        int startX;
                        int color = IAuraType.forLevel((Level)mc.level).getColor();
                        graphics.setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f);
                        int totalAmount2 = IAuraChunk.triangulateAuraInArea((Level)mc.level, mc.player.blockPosition(), 35);
                        float totalPercentage = (float)totalAmount2 / 2000000.0f;
                        String text = I18n.get((String)"info.naturesaura.aura_in_area", (Object[])new Object[0]);
                        float textScale = 0.75f;
                        int n = startX = conf % 2 == 0 ? 3 : res.getGuiScaledWidth() - 3 - 6;
                        int startY = conf < 2 ? 10 : (!heldOcular.isEmpty() && (totalPercentage > 1.0f || totalPercentage < 0.0f) ? -26 : 0) + res.getGuiScaledHeight() - 60;
                        float plusOffX = conf % 2 == 0 ? 7.0f : -7.0f;
                        float textX = conf % 2 == 0 ? 3.0f : (float)(res.getGuiScaledWidth() - 3) - (float)mc.font.width(text) * textScale;
                        float textY = conf < 2 ? 3.0f : (float)(res.getGuiScaledHeight() - 3 - 6);
                        int tHeight = Mth.ceil((float)(Mth.clamp((float)totalPercentage, (float)0.0f, (float)1.0f) * 50.0f));
                        int n2 = y = !heldOcular.isEmpty() && totalPercentage > 1.0f ? startY + 26 : startY;
                        if (tHeight < 50) {
                            graphics.blit(OVERLAYS, startX, y, 6.0f, 12.0f, 6, 50 - tHeight, 256, 256);
                        }
                        if (tHeight > 0) {
                            graphics.blit(OVERLAYS, startX, y + 50 - tHeight, 0.0f, (float)(62 - tHeight), 6, tHeight, 256, 256);
                        }
                        if (!heldOcular.isEmpty()) {
                            int bottomHeight;
                            int topHeight = Mth.ceil((float)(Mth.clamp((float)((totalPercentage - 1.0f) * 2.0f), (float)0.0f, (float)1.0f) * 25.0f));
                            if (topHeight > 0) {
                                if (topHeight < 25) {
                                    graphics.blit(OVERLAYS, startX, startY, 18.0f, 12.0f, 6, 25 - topHeight, 256, 256);
                                }
                                graphics.blit(OVERLAYS, startX, startY + 25 - topHeight, 12.0f, (float)(37 - topHeight), 6, topHeight, 256, 256);
                            }
                            if ((bottomHeight = Mth.floor((float)(Mth.clamp((float)((totalPercentage + 1.0f) * 2.0f - 1.0f), (float)0.0f, (float)1.0f) * 25.0f))) < 25) {
                                graphics.blit(OVERLAYS, startX, startY + 51, 18.0f, 12.0f, 6, 25 - bottomHeight, 256, 256);
                                if (bottomHeight > 0) {
                                    graphics.blit(OVERLAYS, startX, startY + 51 + 25 - bottomHeight, 12.0f, (float)(37 - bottomHeight), 6, bottomHeight, 256, 256);
                                }
                            }
                        }
                        float f = heldOcular.isEmpty() ? 1.0f : 1.5f;
                        if (totalPercentage > f) {
                            graphics.drawString(mc.font, "+", (float)startX + plusOffX, (float)startY - 0.5f, color, true);
                        }
                        float f2 = heldOcular.isEmpty() ? 0.0f : -0.5f;
                        if (totalPercentage < f2) {
                            graphics.drawString(mc.font, "-", (float)startX + plusOffX, (float)startY - 0.5f + (float)(heldOcular.isEmpty() ? 44 : 70), color, true);
                        }
                        stack.pushPose();
                        stack.scale(textScale, textScale, textScale);
                        graphics.drawString(mc.font, text, textX / textScale, textY / textScale, color, true);
                        stack.popPose();
                        if (!heldOcular.isEmpty()) {
                            stack.pushPose();
                            int stackX = conf % 2 == 0 ? 10 : res.getGuiScaledWidth() - 22;
                            int stackY = conf < 2 ? 10 : res.getGuiScaledHeight() - 60;
                            for (Tuple<ItemStack, Boolean> effect : SHOWING_EFFECTS.values()) {
                                ItemStack itemStack = (ItemStack)effect.getA();
                                Helper.renderItemInGui(graphics, itemStack, stackX, stackY, 1.0f);
                                if (((Boolean)effect.getB()).booleanValue()) {
                                    RenderSystem.disableDepthTest();
                                    graphics.blit(OVERLAYS, stackX, stackY, 240.0f, 0.0f, 16, 16, 256, 256);
                                    RenderSystem.enableDepthTest();
                                }
                                stackY += 12;
                            }
                            stack.popPose();
                        }
                    }
                    if ((totalAmount2 = mc.hitResult) instanceof BlockHitResult && (pos = (blockHitResult = (BlockHitResult)totalAmount2).getBlockPos()) != null) {
                        IAuraContainer container;
                        BlockEntity tile = mc.level.getBlockEntity(pos);
                        int x = res.getGuiScaledWidth() / 2;
                        int y = res.getGuiScaledHeight() / 2;
                        if (tile != null && (container = (IAuraContainer)tile.getLevel().getCapability(NaturesAuraAPI.AURA_CONTAINER_BLOCK_CAPABILITY, tile.getBlockPos(), tile.getBlockState(), tile, null)) != null) {
                            IAuraContainer stackCont;
                            IItemHandler itemHandler;
                            ItemStack tileStack;
                            BlockState state = mc.level.getBlockState(pos);
                            ItemStack blockStack = state.getBlock().getCloneItemStack(state, (HitResult)blockHitResult, (LevelReader)mc.level, pos, (Player)mc.player);
                            this.drawContainerInfo(graphics, container.getStoredAura(), container.getMaxAura(), container.getAuraColor(), mc, res, 35, blockStack.getHoverName().getString(), null);
                            if (tile instanceof BlockEntityNatureAltar && !(tileStack = (itemHandler = (IItemHandler)tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), tile.getBlockState(), tile, null)).getStackInSlot(0)).isEmpty() && (stackCont = (IAuraContainer)tileStack.getCapability(NaturesAuraAPI.AURA_CONTAINER_ITEM_CAPABILITY)) != null) {
                                this.drawContainerInfo(graphics, stackCont.getStoredAura(), stackCont.getMaxAura(), stackCont.getAuraColor(), mc, res, 55, tileStack.getHoverName().getString(), null);
                            }
                        } else if (tile instanceof BlockEntityRFConverter) {
                            BlockEntityRFConverter.RFStorage storage = ((BlockEntityRFConverter)tile).storage;
                            this.drawContainerInfo(graphics, storage.getEnergyStored(), storage.getMaxEnergyStored(), 13388054, mc, res, 35, I18n.get((String)"block.naturesaura.rf_converter", (Object[])new Object[0]), storage.getEnergyStored() + " / " + storage.getMaxEnergyStored() + " RF");
                        } else if (tile instanceof BlockEntityGratedChute) {
                            BlockEntityGratedChute chute = (BlockEntityGratedChute)tile;
                            IItemHandler itemHandler = (IItemHandler)tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), tile.getBlockState(), tile, null);
                            ItemStack itemStack = itemHandler.getStackInSlot(0);
                            if (itemStack.isEmpty()) {
                                graphics.drawString(mc.font, ChatFormatting.GRAY.toString() + ChatFormatting.ITALIC + I18n.get((String)"info.naturesaura.empty", (Object[])new Object[0]), x + 5, y - 11, 0xFFFFFF);
                            } else {
                                Helper.renderItemInGui(graphics, itemStack, x + 2, y - 18, 1.0f);
                            }
                            Helper.renderItemInGui(graphics, ITEM_FRAME, x - 24, y - 24, 1.0f);
                            int u = chute.isBlacklist ? 240 : 224;
                            RenderSystem.disableDepthTest();
                            graphics.blit(OVERLAYS, x - 18, y - 18, (float)u, 0.0f, 16, 16, 256, 256);
                            RenderSystem.enableDepthTest();
                        } else if (tile instanceof BlockEntityItemDistributor) {
                            BlockEntityItemDistributor distributor = (BlockEntityItemDistributor)tile;
                            Helper.renderItemInGui(graphics, DISPENSER, x - 24, y - 24, 1.0f);
                            int u = !distributor.isRandomMode ? 240 : 224;
                            RenderSystem.disableDepthTest();
                            graphics.blit(OVERLAYS, x - 18, y - 18, (float)u, 0.0f, 16, 16, 256, 256);
                            RenderSystem.enableDepthTest();
                        } else if (tile instanceof BlockEntityAuraTimer) {
                            BlockEntityAuraTimer timer = (BlockEntityAuraTimer)tile;
                            IItemHandler itemHandler = (IItemHandler)tile.getLevel().getCapability(Capabilities.ItemHandler.BLOCK, tile.getBlockPos(), tile.getBlockState(), tile, null);
                            ItemStack itemStack = itemHandler.getStackInSlot(0);
                            if (!itemStack.isEmpty()) {
                                Helper.renderItemInGui(graphics, itemStack, x - 20, y - 20, 1.0f);
                                graphics.drawString(mc.font, ChatFormatting.GRAY + this.createTimeString(timer.getTotalTime()), x + 5, y - 11, 0xFFFFFF);
                                graphics.drawString(mc.font, ChatFormatting.GRAY + I18n.get((String)"info.naturesaura.remaining", (Object[])new Object[]{this.createTimeString(timer.getTimeLeft())}), x + 5, y + 3, 0xFFFFFF);
                            }
                        }
                    }
                    graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
                    stack.popPose();
                }
                if (hoveringAuraSpot != null) {
                    NumberFormat format = NumberFormat.getInstance();
                    AuraChunk.DrainSpot spot = IAuraChunk.getAuraChunk((Level)mc.level, hoveringAuraSpot).getActualDrainSpot(hoveringAuraSpot, false);
                    ChatFormatting color = spot.intValue() > 0 ? ChatFormatting.GREEN : ChatFormatting.RED;
                    graphics.drawString(mc.font, "Pos: " + spot.pos.toShortString(), (float)res.getGuiScaledWidth() / 2.0f + 5.0f, (float)res.getGuiScaledHeight() / 2.0f - 20.0f, 0xFFFFFF, true);
                    graphics.drawString(mc.font, "Amount: " + color + format.format(spot.intValue()), (float)res.getGuiScaledWidth() / 2.0f + 5.0f, (float)res.getGuiScaledHeight() / 2.0f - 10.0f, 0xFFFFFF, true);
                    if (spot.originalSpreadPos != null) {
                        graphics.drawString(mc.font, "Dist from Original: " + (int)Math.sqrt(spot.pos.distSqr((Vec3i)spot.originalSpreadPos)) + " (" + spot.originalSpreadPos.toShortString() + ")", (float)res.getGuiScaledWidth() / 2.0f + 5.0f, (float)res.getGuiScaledHeight() / 2.0f, 0xFFFFFF, true);
                    }
                }
            }
        }
    }

    private String createTimeString(int totalTicks) {
        int ticks = totalTicks % 20;
        int seconds = totalTicks / 20 % 60;
        int minutes = totalTicks / 20 / 60 % 60;
        int hours = totalTicks / 20 / 60 / 60;
        return String.format("%02d:%02d:%02d.%02d", hours, minutes, seconds, ticks);
    }

    private void drawContainerInfo(GuiGraphics graphics, int stored, int max, int color, Minecraft mc, Window res, int yOffset, String name, String textBelow) {
        graphics.setColor((float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f, 1.0f);
        int x = res.getGuiScaledWidth() / 2 - 40;
        int y = res.getGuiScaledHeight() / 2 + yOffset;
        int width = Mth.ceil((float)((float)stored / (float)max * 80.0f));
        if (width < 80) {
            graphics.blit(OVERLAYS, x + width, y, (float)width, 0.0f, 80 - width, 6, 256, 256);
        }
        if (width > 0) {
            graphics.blit(OVERLAYS, x, y, 0.0f, 6.0f, width, 6, 256, 256);
        }
        graphics.drawString(mc.font, name, (float)(x + 40) - (float)mc.font.width(name) / 2.0f, (float)(y - 9), color, true);
        if (textBelow != null) {
            graphics.drawString(mc.font, textBelow, (float)(x + 40) - (float)mc.font.width(textBelow) / 2.0f, (float)(y + 7), color, true);
        }
    }
}

