/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.events;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.mojang.brigadier.CommandDispatcher;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.commands.CommandAura;
import de.ellpeck.naturesaura.misc.LevelData;
import de.ellpeck.naturesaura.packet.PacketHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.UUID;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.util.ObfuscationReflectionHelper;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.TickEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.level.ChunkEvent;
import net.neoforged.neoforge.event.level.ChunkWatchEvent;

public class CommonEvents {
    private static final Method GET_LOADED_CHUNKS_METHOD = ObfuscationReflectionHelper.findMethod(ChunkMap.class, (String)"getChunks", (Class[])new Class[0]);
    private static final ListMultimap<UUID, ChunkPos> PENDING_AURA_CHUNKS = ArrayListMultimap.create();

    @SubscribeEvent
    public void onChunkUnload(ChunkEvent.Unload event) {
        LevelChunk chunk;
        IAuraChunk auraChunk;
        ChunkAccess iChunk = event.getChunk();
        if (iChunk instanceof LevelChunk && (auraChunk = (IAuraChunk)(chunk = (LevelChunk)iChunk).getData(NaturesAuraAPI.AURA_CHUNK_ATTACHMENT)) instanceof AuraChunk) {
            LevelData data = (LevelData)ILevelData.getLevelData(chunk.getLevel());
            data.auraChunksWithSpots.remove(chunk.getPos().toLong());
        }
    }

    @SubscribeEvent
    public void onItemUse(PlayerInteractEvent.RightClickBlock event) {
        BlockState state;
        Player player = event.getEntity();
        if (player.level().isClientSide) {
            return;
        }
        ItemStack held = event.getItemStack();
        if (!held.isEmpty() && BuiltInRegistries.ITEM.getKey((Object)held.getItem()).getPath().contains("chisel") && NaturesAuraAPI.BOTANIST_PICKAXE_CONVERSIONS.containsKey((Object)(state = player.level().getBlockState(event.getPos())))) {
            LevelData data = (LevelData)ILevelData.getLevelData(player.level());
            data.addMossStone(event.getPos());
        }
    }

    @SubscribeEvent
    public void onLevelTick(TickEvent.LevelTickEvent event) {
        if (!event.level.isClientSide && event.phase == TickEvent.Phase.END && event.level.getGameTime() % 20L == 0L) {
            event.level.getProfiler().push("naturesaura:onLevelTick");
            try {
                ChunkMap manager = ((ServerChunkCache)event.level.getChunkSource()).chunkMap;
                Iterable chunks = (Iterable)GET_LOADED_CHUNKS_METHOD.invoke((Object)manager, new Object[0]);
                for (ChunkHolder holder : chunks) {
                    AuraChunk auraChunk;
                    LevelChunk chunk = holder.getTickingChunk();
                    if (chunk == null || (auraChunk = (AuraChunk)chunk.getData(NaturesAuraAPI.AURA_CHUNK_ATTACHMENT)) == null) continue;
                    auraChunk.update();
                }
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                NaturesAura.LOGGER.fatal((Object)e);
            }
            event.level.getProfiler().pop();
        }
    }

    @SubscribeEvent
    public void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.level().isClientSide && event.phase == TickEvent.Phase.END) {
            if (event.player.level().getGameTime() % 10L == 0L) {
                List pending = PENDING_AURA_CHUNKS.get((Object)event.player.getUUID());
                pending.removeIf(p -> this.handleChunkWatchDeferred(event.player, (ChunkPos)p));
            }
            if (event.player.level().getGameTime() % 200L != 0L) {
                return;
            }
            int aura = IAuraChunk.triangulateAuraInArea(event.player.level(), event.player.blockPosition(), 25);
            if (aura <= 0) {
                Helper.addAdvancement(event.player, new ResourceLocation("naturesaura", "negative_imbalance"), "triggered_in_code");
            } else if (aura >= 1500000) {
                Helper.addAdvancement(event.player, new ResourceLocation("naturesaura", "positive_imbalance"), "triggered_in_code");
            }
        }
    }

    @SubscribeEvent
    public void onChunkWatch(ChunkWatchEvent.Watch event) {
        PENDING_AURA_CHUNKS.put((Object)event.getPlayer().getUUID(), (Object)event.getPos());
    }

    private boolean handleChunkWatchDeferred(Player player, ChunkPos pos) {
        ChunkAccess chunk = Helper.getLoadedChunk((LevelAccessor)player.level(), pos.x, pos.z);
        if (!(chunk instanceof LevelChunk)) {
            return false;
        }
        LevelChunk levelChunk = (LevelChunk)chunk;
        AuraChunk auraChunk = (AuraChunk)levelChunk.getData(NaturesAuraAPI.AURA_CHUNK_ATTACHMENT);
        if (auraChunk == null) {
            return false;
        }
        PacketHandler.sendTo(player, auraChunk.makePacket());
        return true;
    }

    @SubscribeEvent
    public void onCommands(RegisterCommandsEvent event) {
        CommandAura.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }
}

