/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.container.IAuraContainer;
import de.ellpeck.naturesaura.api.aura.item.IAuraRecharge;
import de.ellpeck.naturesaura.api.render.ITrinketItem;
import de.ellpeck.naturesaura.enchant.ModEnchantments;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.reg.ICustomCreativeTab;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemAuraCache
extends ItemImpl
implements ITrinketItem,
ICustomCreativeTab {
    public ItemAuraCache(String name) {
        super(name, new Item.Properties().stacksTo(1));
    }

    public void inventoryTick(ItemStack stackIn, Level levelIn, Entity entityIn, int itemSlot, boolean isSelected) {
        Player player;
        if (!levelIn.isClientSide && entityIn instanceof Player && (player = (Player)entityIn).isShiftKeyDown()) {
            IAuraContainer container = (IAuraContainer)stackIn.getCapability(NaturesAuraAPI.AURA_CONTAINER_ITEM_CAPABILITY);
            if (container == null || container.getStoredAura() <= 0) {
                return;
            }
            for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
                boolean isArmor;
                ItemStack stack = player.getInventory().getItem(i);
                IAuraRecharge recharge = (IAuraRecharge)stack.getCapability(NaturesAuraAPI.AURA_RECHARGE_CAPABILITY);
                if (recharge != null) {
                    if (!recharge.rechargeFromContainer(container, itemSlot, i, player.getInventory().selected == i)) continue;
                    break;
                }
                if (stack.getEnchantmentLevel(ModEnchantments.AURA_MENDING) <= 0) continue;
                int mainSize = player.getInventory().items.size();
                boolean bl = isArmor = i >= mainSize && i < mainSize + player.getInventory().armor.size();
                if ((isArmor || player.getInventory().selected == i) && Helper.rechargeAuraItem(stack, container, 1000)) break;
            }
        }
    }

    @Override
    public List<ItemStack> getCreativeTabItems() {
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        ret.add(new ItemStack((ItemLike)this));
        ItemStack full = new ItemStack((ItemLike)this);
        IAuraContainer container = (IAuraContainer)full.getCapability(NaturesAuraAPI.AURA_CONTAINER_ITEM_CAPABILITY);
        container.storeAura(container.getMaxAura(), false);
        ret.add(full);
        return ret;
    }

    public boolean isBarVisible(ItemStack stack) {
        return true;
    }

    public int getBarWidth(ItemStack stack) {
        IAuraContainer container = (IAuraContainer)stack.getCapability(NaturesAuraAPI.AURA_CONTAINER_ITEM_CAPABILITY);
        return container != null ? Math.round((float)container.getStoredAura() / (float)container.getMaxAura() * 13.0f) : 0;
    }

    public int getBarColor(ItemStack stack) {
        IAuraContainer cap = (IAuraContainer)stack.getCapability(NaturesAuraAPI.AURA_CONTAINER_ITEM_CAPABILITY);
        return cap != null ? cap.getAuraColor() : super.getBarColor(stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void render(ItemStack stack, Player player, ITrinketItem.RenderType type, PoseStack matrices, MultiBufferSource buffer, int packedLight, boolean isHolding) {
        if (type == ITrinketItem.RenderType.BODY && !isHolding) {
            boolean legs;
            boolean chest = !((ItemStack)player.getInventory().armor.get(EquipmentSlot.CHEST.getIndex())).isEmpty();
            boolean bl = legs = !((ItemStack)player.getInventory().armor.get(EquipmentSlot.LEGS.getIndex())).isEmpty();
            matrices.translate(-0.15f, 0.65f, chest ? -0.195f : (legs ? -0.165f : -0.1475f));
            matrices.scale(0.5f, 0.5f, 0.5f);
            matrices.mulPose(Axis.XP.rotationDegrees(180.0f));
            Minecraft.getInstance().getItemRenderer().renderStatic(stack, ItemDisplayContext.GROUND, packedLight, OverlayTexture.NO_OVERLAY, matrices, buffer, player.level(), 0);
        }
    }
}

