/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.items.ItemGlowing;
import de.ellpeck.naturesaura.items.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.BabyEntitySpawnEvent;

public class ItemBirthSpirit
extends ItemGlowing {
    public ItemBirthSpirit() {
        super("birth_spirit");
        NeoForge.EVENT_BUS.register((Object)new EventHandler());
    }

    private static class EventHandler {
        private EventHandler() {
        }

        @SubscribeEvent
        public void onBabyBorn(BabyEntitySpawnEvent event) {
            Mob parent = event.getParentA();
            if (!parent.level().isClientSide && event.getCausedByPlayer() != null) {
                BlockPos pos = parent.blockPosition();
                int aura = IAuraChunk.getAuraInArea(parent.level(), pos, 30);
                if (aura < 1200000) {
                    return;
                }
                int amount = parent.level().random.nextInt(3) + 1;
                ItemEntity item = new ItemEntity(parent.level(), parent.getX(), parent.getY(), parent.getZ(), new ItemStack((ItemLike)ModItems.BIRTH_SPIRIT, amount));
                parent.level().addFreshEntity((Entity)item);
                BlockPos spot = IAuraChunk.getHighestSpot(parent.level(), pos, 30, pos);
                IAuraChunk.getAuraChunk(parent.level(), spot).drainAura(spot, 800 * amount);
            }
        }
    }
}

