/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.items.ModItems;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.AnvilUpdateEvent;
import net.neoforged.neoforge.event.entity.player.ItemTooltipEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class ItemBreakPrevention
extends ItemImpl {
    public ItemBreakPrevention() {
        super("break_prevention");
        NeoForge.EVENT_BUS.register((Object)new Events());
    }

    public static class Events {
        @SubscribeEvent
        public void onAnvilUpdate(AnvilUpdateEvent event) {
            ItemStack stack = event.getLeft();
            if (!stack.isDamageableItem()) {
                return;
            }
            ItemStack second = event.getRight();
            if (second.getItem() != ModItems.BREAK_PREVENTION) {
                return;
            }
            ItemStack output = stack.copy();
            output.getOrCreateTag().putBoolean("naturesaura:break_prevention", true);
            event.setOutput(output);
            event.setMaterialCost(1);
            event.setCost(1);
        }

        @SubscribeEvent
        public void onBreakSpeed(PlayerEvent.BreakSpeed event) {
            Player player = event.getEntity();
            if (player == null) {
                return;
            }
            ItemStack stack = player.getMainHandItem();
            if (!stack.hasTag() || !stack.getTag().getBoolean("naturesaura:break_prevention")) {
                return;
            }
            if (ElytraItem.isFlyEnabled((ItemStack)stack)) {
                return;
            }
            event.setNewSpeed(0.0f);
        }

        @SubscribeEvent
        @OnlyIn(value=Dist.CLIENT)
        public void onTooltip(ItemTooltipEvent event) {
            ItemStack stack = event.getItemStack();
            if (!stack.hasTag() || !stack.getTag().getBoolean("naturesaura:break_prevention")) {
                return;
            }
            List tooltip = event.getToolTip();
            tooltip.add(Component.translatable((String)"info.naturesaura.break_prevention").setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            if (ElytraItem.isFlyEnabled((ItemStack)stack)) {
                return;
            }
            if (tooltip.size() < 1) {
                return;
            }
            Component head = (Component)tooltip.get(0);
            if (head instanceof MutableComponent) {
                ((MutableComponent)head).append((Component)Component.translatable((String)"info.naturesaura.broken").setStyle(Style.EMPTY.applyFormat(ChatFormatting.GRAY)));
            }
        }
    }
}

