/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.items.ItemImpl;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;

public class ItemCaveFinder
extends ItemImpl {
    public ItemCaveFinder() {
        super("cave_finder", new Item.Properties().stacksTo(1));
    }

    public InteractionResultHolder<ItemStack> use(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        NaturesAuraAPI.IInternalHooks inst = NaturesAuraAPI.instance();
        if (!inst.extractAuraFromPlayer(playerIn, 20000, levelIn.isClientSide)) {
            return new InteractionResultHolder(InteractionResult.FAIL, (Object)stack);
        }
        if (levelIn.isClientSide) {
            inst.setParticleDepth(false);
            inst.setParticleSpawnRange(64);
            inst.setParticleCulling(false);
            BlockPos pos = playerIn.blockPosition();
            int range = 30;
            for (int x = -range; x <= range; ++x) {
                for (int y = -range; y <= range; ++y) {
                    for (int z = -range; z <= range; ++z) {
                        BlockPos offset = pos.offset(x, y, z);
                        BlockState state = levelIn.getBlockState(offset);
                        try {
                            if (!state.getBlock().isValidSpawn(state, (BlockGetter)levelIn, offset, SpawnPlacements.Type.ON_GROUND, null)) {
                            }
                        }
                        catch (Exception e) {}
                        continue;
                        BlockPos offUp = offset.above();
                        BlockState stateUp = levelIn.getBlockState(offUp);
                        if (stateUp.isCollisionShapeFullBlock((BlockGetter)levelIn, offUp) || stateUp.liquid()) continue;
                        int sky = levelIn.getBrightness(LightLayer.SKY, offUp);
                        int block = levelIn.getBrightness(LightLayer.BLOCK, offUp);
                        if (sky > 0 || block > 0) continue;
                        inst.spawnMagicParticle((float)offset.getX() + 0.5f, (float)offset.getY() + 1.5f, (float)offset.getZ() + 0.5f, 0.0, 0.0, 0.0, 10035457, 2.5f, 600, 0.0f, false, true);
                    }
                }
            }
            inst.setParticleDepth(true);
            inst.setParticleSpawnRange(32);
            inst.setParticleCulling(true);
            playerIn.swing(handIn);
        }
        playerIn.getCooldowns().addCooldown((Item)this, 600);
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }
}

