/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.misc.ColoredBlockHelper;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import java.util.List;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemColorChanger
extends ItemImpl
implements IColorProvidingItem,
ICustomItemModel {
    public ItemColorChanger() {
        super("color_changer", new Item.Properties().stacksTo(1));
    }

    private static boolean changeOrCopyColor(Player player, ItemStack stack, Level level, BlockPos pos, DyeColor firstColor) {
        Block block = level.getBlockState(pos).getBlock();
        List<Block> blocks = ColoredBlockHelper.getBlocksContaining(block);
        if (blocks == null) {
            return false;
        }
        DyeColor color = DyeColor.byId((int)blocks.indexOf(block));
        if (firstColor == null || color == firstColor) {
            DyeColor stored = ItemColorChanger.getStoredColor(stack);
            if (player.isShiftKeyDown()) {
                if (stored != color) {
                    level.playSound(player, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.BUCKET_FILL, SoundSource.PLAYERS, 0.65f, 1.0f);
                    if (!level.isClientSide) {
                        ItemColorChanger.storeColor(stack, color);
                    }
                    return true;
                }
            } else if (stored != null && stored != color && NaturesAuraAPI.instance().extractAuraFromPlayer(player, 1000, level.isClientSide)) {
                if (firstColor == null) {
                    level.playSound(player, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, SoundEvents.BUCKET_EMPTY, SoundSource.PLAYERS, 0.65f, 1.0f);
                }
                if (!level.isClientSide) {
                    level.setBlockAndUpdate(pos, blocks.get(stored.getId()).defaultBlockState());
                    if (ItemColorChanger.isFillMode(stack)) {
                        for (Direction off : Direction.values()) {
                            ItemColorChanger.changeOrCopyColor(player, stack, level, pos.relative(off), color);
                        }
                    }
                }
                return true;
            }
        }
        return false;
    }

    public static DyeColor getStoredColor(ItemStack stack) {
        if (!stack.hasTag()) {
            return null;
        }
        int color = stack.getTag().getInt("color");
        return DyeColor.byId((int)color);
    }

    private static void storeColor(ItemStack stack, DyeColor color) {
        stack.getOrCreateTag().putInt("color", color.getId());
    }

    public static boolean isFillMode(ItemStack stack) {
        if (!stack.hasTag()) {
            return false;
        }
        return stack.getTag().getBoolean("fill");
    }

    private static void setFillMode(ItemStack stack, boolean fill) {
        stack.getOrCreateTag().putBoolean("fill", fill);
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
        if (ItemColorChanger.changeOrCopyColor(context.getPlayer(), stack, context.getLevel(), context.getClickedPos(), null)) {
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> use(Level levelIn, Player playerIn, InteractionHand handIn) {
        ItemStack stack = playerIn.getItemInHand(handIn);
        if (playerIn.isShiftKeyDown() && ItemColorChanger.getStoredColor(stack) != null) {
            levelIn.playSound(playerIn, playerIn.getX(), playerIn.getY(), playerIn.getZ(), SoundEvents.BUCKET_FILL_LAVA, SoundSource.PLAYERS, 0.65f, 1.0f);
            if (!levelIn.isClientSide) {
                ItemColorChanger.setFillMode(stack, !ItemColorChanger.isFillMode(stack));
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        return (stack, tintIndex) -> {
            DyeColor color;
            if (tintIndex > 0 && (color = ItemColorChanger.getStoredColor(stack)) != null) {
                return color.getFireworkColor();
            }
            return 0xFFFFFF;
        };
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
    }
}

