/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.entities.EntityEffectInhibitor;
import de.ellpeck.naturesaura.items.ItemImpl;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.ICustomCreativeTab;
import java.util.List;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class ItemEffectPowder
extends ItemImpl
implements IColorProvidingItem,
ICustomCreativeTab {
    public ItemEffectPowder() {
        super("effect_powder");
    }

    public static ResourceLocation getEffect(ItemStack stack) {
        if (!stack.hasTag()) {
            return null;
        }
        String effect = stack.getTag().getString("effect");
        if (effect.isEmpty()) {
            return null;
        }
        return new ResourceLocation(effect);
    }

    public static ItemStack setEffect(ItemStack stack, ResourceLocation effect) {
        stack.getOrCreateTag().putString("effect", effect != null ? effect.toString() : "");
        return stack;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level level = context.getLevel();
        if (!level.isClientSide) {
            Vec3 hit = context.getClickLocation();
            ItemStack stack = context.getPlayer().getItemInHand(context.getHand());
            EntityEffectInhibitor.place(level, stack, hit.x, hit.y + 1.0, hit.z);
            stack.setCount(0);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public List<ItemStack> getCreativeTabItems() {
        return NaturesAuraAPI.EFFECT_POWDERS.keySet().stream().map(e -> ItemEffectPowder.setEffect(new ItemStack((ItemLike)this), e)).toList();
    }

    public Component getName(ItemStack stack) {
        return Component.translatable((String)(this.getDescriptionId(stack) + "." + ItemEffectPowder.getEffect(stack)));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ItemColor getItemColor() {
        return (stack, tintIndex) -> NaturesAuraAPI.EFFECT_POWDERS.getOrDefault(ItemEffectPowder.getEffect(stack), 0xFFFFFF);
    }
}

