/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.items.tools;

import de.ellpeck.naturesaura.data.ItemModelGenerator;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.reg.ICustomItemModel;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ModRegistry;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import org.jetbrains.annotations.NotNull;

public class ItemSword
extends SwordItem
implements IModItem,
ICustomItemModel {
    private final String baseName;

    public ItemSword(String baseName, Tier material, int damage, float speed) {
        super(material, damage, speed, new Item.Properties());
        this.baseName = baseName;
        ModRegistry.ALL_ITEMS.add(this);
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    public boolean hurtEnemy(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this == ModItems.INFUSED_IRON_SWORD) {
            target.addEffect(new MobEffectInstance(MobEffects.MOVEMENT_SLOWDOWN, 60, 2));
        } else if (this == ModItems.SKY_SWORD) {
            target.addEffect(new MobEffectInstance(MobEffects.LEVITATION, 60, 2));
        } else if (this == ModItems.DEPTH_SWORD && attacker instanceof Player) {
            Player player = (Player)attacker;
            float damage = (float)player.getAttributeValue(Attributes.ATTACK_DAMAGE) * 0.75f;
            for (LivingEntity other : player.level().getEntitiesOfClass(LivingEntity.class, stack.getSweepHitBox(player, (Entity)target))) {
                ArmorStand stand;
                if (other == player || other == target || player.isAlliedTo((Entity)other) || other instanceof ArmorStand && (stand = (ArmorStand)other).isMarker() || !(player.distanceToSqr((Entity)other) < Mth.square((double)player.getEntityReach()))) continue;
                other.knockback((double)0.4f, (double)Mth.sin((float)(player.getYRot() * ((float)Math.PI / 180))), (double)(-Mth.cos((float)(player.getYRot() * ((float)Math.PI / 180)))));
                other.hurt(other.damageSources().playerAttack(player), damage);
            }
            player.sweepAttack();
        }
        return super.hurtEnemy(stack, target, attacker);
    }

    @NotNull
    public AABB getSweepHitBox(@NotNull ItemStack stack, @NotNull Player player, @NotNull Entity target) {
        if (this == ModItems.DEPTH_SWORD) {
            return target.getBoundingBox().inflate(2.0, 1.0, 2.0);
        }
        return super.getSweepHitBox(stack, player, target);
    }

    @Override
    public void generateCustomItemModel(ItemModelGenerator generator) {
        ((ItemModelBuilder)generator.withExistingParent(this.getBaseName(), "item/handheld")).texture("layer0", "item/" + this.getBaseName());
    }
}

