/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.misc;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.api.misc.ILevelData;
import de.ellpeck.naturesaura.blocks.tiles.BlockEntitySpawnLamp;
import de.ellpeck.naturesaura.blocks.tiles.ItemStackHandlerNA;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.items.ModItems;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;

public class LevelData
extends SavedData
implements ILevelData {
    public static final SavedData.Factory<LevelData> FACTORY = new SavedData.Factory(LevelData::new, LevelData::new);
    public static LevelData client;
    public final ListMultimap<ResourceLocation, Tuple<Vec3, Integer>> effectPowders = ArrayListMultimap.create();
    public final Long2ObjectOpenHashMap<AuraChunk> auraChunksWithSpots = new Long2ObjectOpenHashMap();
    public final List<BlockPos> recentlyConvertedMossStones = new ArrayList<BlockPos>();
    public final Set<BlockEntitySpawnLamp> spawnLamps = new HashSet<BlockEntitySpawnLamp>();
    private final Map<String, ItemStackHandlerNA> enderStorages = new HashMap<String, ItemStackHandlerNA>();
    public Level level;

    public LevelData() {
    }

    public LevelData(CompoundTag compound) {
        for (Tag base : compound.getList("storages", 10)) {
            CompoundTag storageComp = (CompoundTag)base;
            ItemStackHandlerNA storage = this.getEnderStorage(storageComp.getString("name"));
            storage.deserializeNBT(storageComp);
        }
        for (Tag base : compound.getList("converted_moss", 4)) {
            this.recentlyConvertedMossStones.add(BlockPos.of((long)((LongTag)base).getAsLong()));
        }
    }

    public CompoundTag save(CompoundTag compound) {
        ListTag storages = new ListTag();
        for (Map.Entry<String, ItemStackHandlerNA> entry : this.enderStorages.entrySet()) {
            ItemStackHandlerNA handler = entry.getValue();
            if (Helper.isEmpty((IItemHandler)handler)) continue;
            CompoundTag storageComp = handler.serializeNBT();
            storageComp.putString("name", entry.getKey());
            storages.add((Object)storageComp);
        }
        compound.put("storages", (Tag)storages);
        ListTag moss = new ListTag();
        for (BlockPos pos : this.recentlyConvertedMossStones) {
            moss.add((Object)LongTag.valueOf((long)pos.asLong()));
        }
        compound.put("converted_moss", (Tag)moss);
        return compound;
    }

    public boolean isDirty() {
        return true;
    }

    public ItemStackHandlerNA getEnderStorage(String name) {
        return this.enderStorages.computeIfAbsent(name, n -> new ItemStackHandlerNA(27));
    }

    @Override
    public boolean isEnderStorageLocked(String name) {
        ItemStackHandlerNA handler = this.getEnderStorage(name);
        for (int i = 0; i < handler.getSlots(); ++i) {
            ItemStack stack = handler.getStackInSlot(i);
            if (stack.isEmpty() || stack.getItem() != ModItems.TOKEN_TERROR) continue;
            return true;
        }
        return false;
    }

    public void addMossStone(BlockPos pos) {
        this.recentlyConvertedMossStones.add(pos);
        if (this.recentlyConvertedMossStones.size() > 512) {
            this.recentlyConvertedMossStones.remove(0);
        }
    }
}

