/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.packet;

import de.ellpeck.naturesaura.NaturesAura;
import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.chunk.AuraChunk;
import de.ellpeck.naturesaura.events.ClientEvents;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PacketAuraChunk
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("naturesaura", "aura_chunk");
    private final int chunkX;
    private final int chunkZ;
    private final Collection<AuraChunk.DrainSpot> drainSpots;

    public PacketAuraChunk(int chunkX, int chunkZ, Collection<AuraChunk.DrainSpot> drainSpots) {
        this.chunkX = chunkX;
        this.chunkZ = chunkZ;
        this.drainSpots = drainSpots;
    }

    public PacketAuraChunk(FriendlyByteBuf buf) {
        this.chunkX = buf.readInt();
        this.chunkZ = buf.readInt();
        this.drainSpots = new ArrayList<AuraChunk.DrainSpot>();
        int amount = buf.readInt();
        for (int i = 0; i < amount; ++i) {
            this.drainSpots.add(new AuraChunk.DrainSpot(buf.readNbt()));
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeInt(this.chunkX);
        buf.writeInt(this.chunkZ);
        buf.writeInt(this.drainSpots.size());
        for (AuraChunk.DrainSpot entry : this.drainSpots) {
            buf.writeNbt((Tag)entry.serializeNBT());
        }
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void onMessage(PacketAuraChunk message, PlayPayloadContext ctx) {
        ctx.workHandler().execute(() -> ClientEvents.PENDING_AURA_CHUNKS.add(message));
    }

    public boolean tryHandle(Level level) {
        try {
            LevelChunk chunk = level.getChunk(this.chunkX, this.chunkZ);
            if (chunk.isEmpty()) {
                return false;
            }
            AuraChunk auraChunk = (AuraChunk)chunk.getData(NaturesAuraAPI.AURA_CHUNK_ATTACHMENT);
            if (auraChunk == null) {
                return false;
            }
            auraChunk.setSpots(this.drainSpots);
            return true;
        }
        catch (Exception e) {
            NaturesAura.LOGGER.error("There was an error handling an aura chunk packet", (Throwable)e);
            return true;
        }
    }
}

