/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.packet;

import de.ellpeck.naturesaura.items.ItemRangeVisualizer;
import de.ellpeck.naturesaura.items.ModItems;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PacketClient
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("naturesaura", "client");
    private final int type;
    private final CompoundTag data;

    public PacketClient(int type, CompoundTag data) {
        this.type = type;
        this.data = data;
    }

    public PacketClient(FriendlyByteBuf buf) {
        this.type = buf.readByte();
        this.data = buf.readNbt();
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeByte(this.type);
        buf.writeNbt((Tag)this.data);
    }

    public ResourceLocation id() {
        return ID;
    }

    public static void onMessage(PacketClient message, PlayPayloadContext ctx) {
        ctx.workHandler().execute(() -> {
            Minecraft mc = Minecraft.getInstance();
            if (mc.level != null) {
                switch (message.type) {
                    case 0: {
                        ResourceLocation goalDim = new ResourceLocation(message.data.getString("dim"));
                        BlockPos goalPos = BlockPos.of((long)message.data.getLong("pos"));
                        ItemRangeVisualizer.visualize((Player)mc.player, ItemRangeVisualizer.VISUALIZED_RAILS, goalDim, goalPos);
                    }
                    case 1: {
                        Entity entity = mc.level.getEntity(message.data.getInt("id"));
                        mc.particleEngine.createTrackingEmitter(entity, (ParticleOptions)ParticleTypes.TOTEM_OF_UNDYING, 30);
                        mc.level.playLocalSound(entity.getX(), entity.getY(), entity.getZ(), SoundEvents.TOTEM_USE, entity.getSoundSource(), 1.0f, 1.0f, false);
                        if (entity != mc.player) break;
                        mc.gameRenderer.displayItemActivation(new ItemStack((ItemLike)ModItems.DEATH_RING));
                    }
                }
            }
        });
    }
}

