/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.packet;

import de.ellpeck.naturesaura.packet.PacketAuraChunk;
import de.ellpeck.naturesaura.packet.PacketClient;
import de.ellpeck.naturesaura.packet.PacketParticleStream;
import de.ellpeck.naturesaura.packet.PacketParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlerEvent;
import net.neoforged.neoforge.network.registration.IPayloadRegistrar;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class PacketHandler {
    @SubscribeEvent
    public static void onPayloadRegister(RegisterPayloadHandlerEvent event) {
        IPayloadRegistrar registrar = event.registrar("naturesaura");
        registrar.play(PacketAuraChunk.ID, PacketAuraChunk::new, PacketAuraChunk::onMessage);
        registrar.play(PacketClient.ID, PacketClient::new, PacketClient::onMessage);
        registrar.play(PacketParticles.ID, PacketParticles::new, PacketParticles::onMessage);
        registrar.play(PacketParticleStream.ID, PacketParticleStream::new, PacketParticleStream::onMessage);
    }

    public static void sendToAllLoaded(Level level, BlockPos pos, CustomPacketPayload message) {
        PacketDistributor.TRACKING_CHUNK.with((Object)level.getChunkAt(pos)).send(new CustomPacketPayload[]{message});
    }

    public static void sendToAllAround(Level level, BlockPos pos, int range, CustomPacketPayload message) {
        PacketDistributor.NEAR.with((Object)new PacketDistributor.TargetPoint((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)range, level.dimension())).send(new CustomPacketPayload[]{message});
    }

    public static void sendTo(Player player, CustomPacketPayload message) {
        ((ServerPlayer)player).connection.send(message);
    }
}

