/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.packet;

import de.ellpeck.naturesaura.api.NaturesAuraAPI;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import de.ellpeck.naturesaura.api.aura.type.IAuraType;
import de.ellpeck.naturesaura.blocks.multi.Multiblocks;
import de.ellpeck.naturesaura.entities.EntityStructureFinder;
import java.util.function.BiConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.neoforged.neoforge.network.handling.PlayPayloadContext;

public class PacketParticles
implements CustomPacketPayload {
    public static final ResourceLocation ID = new ResourceLocation("naturesaura", "particles");
    private final float posX;
    private final float posY;
    private final float posZ;
    private final Type type;
    private final int[] data;

    public PacketParticles(float posX, float posY, float posZ, Type type, int ... data) {
        this.posX = posX;
        this.posY = posY;
        this.posZ = posZ;
        this.type = type;
        this.data = data;
    }

    public PacketParticles(FriendlyByteBuf buf) {
        this.posX = buf.readFloat();
        this.posY = buf.readFloat();
        this.posZ = buf.readFloat();
        this.type = Type.values()[buf.readByte()];
        this.data = new int[buf.readByte()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = buf.readInt();
        }
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeFloat(this.posX);
        buf.writeFloat(this.posY);
        buf.writeFloat(this.posZ);
        buf.writeByte(this.type.ordinal());
        buf.writeByte(this.data.length);
        for (int i : this.data) {
            buf.writeInt(i);
        }
    }

    public ResourceLocation id() {
        return null;
    }

    public static void onMessage(PacketParticles message, PlayPayloadContext ctx) {
        ctx.workHandler().execute(() -> {
            ClientLevel level = Minecraft.getInstance().level;
            if (level != null) {
                message.type.action.accept(message, (Level)level);
            }
        });
    }

    public static enum Type {
        TR_GOLD_POWDER((message, level) -> {
            BlockPos pos = BlockPos.containing((double)message.posX, (double)message.posY, (double)message.posZ);
            Multiblocks.TREE_RITUAL.forEach(pos, 'G', (dustPos, matcher) -> {
                BlockState state = level.getBlockState(dustPos);
                AABB box = state.getShape((BlockGetter)level, dustPos).bounds();
                NaturesAuraAPI.instance().spawnMagicParticle((double)dustPos.getX() + box.minX + (box.maxX - box.minX) * (double)level.random.nextFloat(), (float)dustPos.getY() + 0.1f, (double)dustPos.getZ() + box.minZ + (box.maxZ - box.minZ) * (double)level.random.nextFloat(), (float)level.random.nextGaussian() * 0.02f, level.random.nextFloat() * 0.01f + 0.02f, (float)level.random.nextGaussian() * 0.02f, 16042818, 2.0f, 50, 0.0f, false, true);
                return true;
            });
        }),
        TR_CONSUME_ITEM((message, level) -> {
            for (int i = level.random.nextInt(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.5f, message.posY + 0.9f, message.posZ + 0.5f, (float)level.random.nextGaussian() * 0.04f, level.random.nextFloat() * 0.04f, (float)level.random.nextGaussian() * 0.04f, 9030711, 1.5f, 25, 0.0f, false, true);
            }
        }),
        TR_DISAPPEAR((message, level) -> {
            for (int i = level.random.nextInt(5) + 3; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + level.random.nextFloat(), message.posY + level.random.nextFloat(), message.posZ + level.random.nextFloat(), 0.0, 0.0, 0.0, 0x33FF33, 1.0f, 50, 0.0f, false, true);
            }
        }),
        TR_SPAWN_RESULT((message, level) -> {
            for (int i = level.random.nextInt(10) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY, message.posZ, level.random.nextGaussian() * (double)0.1f, level.random.nextGaussian() * (double)0.1f, level.random.nextGaussian() * (double)0.1f, 9030711, 2.0f, 100, 0.0f, true, true);
            }
        }),
        ALTAR_CONVERSION((message, level) -> {
            int color = message.data[0];
            for (int i = level.random.nextInt(5) + 2; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + level.random.nextFloat() * 0.5f, message.posY + 0.9f + 0.25f * level.random.nextFloat(), message.posZ + 0.25f + level.random.nextFloat() * 0.5f, level.random.nextGaussian() * (double)0.02f, level.random.nextFloat() * 0.02f, level.random.nextGaussian() * (double)0.02f, color, level.random.nextFloat() * 1.5f + 0.75f, 20, 0.0f, false, true);
            }
        }),
        POTION_GEN((message, level) -> {
            int color = message.data[0];
            boolean releaseAura = message.data[1] > 0;
            for (int i = level.random.nextInt(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + level.random.nextFloat(), message.posY + 1.1f, message.posZ + level.random.nextFloat(), level.random.nextGaussian() * (double)0.01f, level.random.nextFloat() * 0.1f, level.random.nextGaussian() * (double)0.01f, color, 2.0f + level.random.nextFloat(), 40, 0.0f, true, true);
                if (!releaseAura) continue;
                for (int x = -1; x <= 1; x += 2) {
                    for (int z = -1; z <= 1; z += 2) {
                        NaturesAuraAPI.instance().spawnMagicParticle(message.posX + (float)(x * 3) + 0.5f, (double)message.posY + 2.5, message.posZ + (float)(z * 3) + 0.5f, level.random.nextGaussian() * (double)0.02f, level.random.nextFloat() * 0.04f, level.random.nextGaussian() * (double)0.02f, 14038028, 1.0f + level.random.nextFloat() * 2.0f, 75, 0.0f, true, true);
                    }
                }
            }
        }),
        PLANT_BOOST((message, level) -> {
            for (int i = level.random.nextInt(20) + 15; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + level.random.nextFloat(), message.posY + 0.25f + level.random.nextFloat() * 0.5f, message.posZ + level.random.nextFloat(), 0.0, level.random.nextFloat() * 0.02f, 0.0, 6081584, 1.0f + level.random.nextFloat() * 2.0f, 50, 0.0f, false, true);
            }
        }),
        FLOWER_GEN_CONSUME((message, level) -> {
            int color = message.data[0];
            for (int i = level.random.nextInt(10) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + level.random.nextFloat() * 0.5f, message.posY + 0.25f + level.random.nextFloat() * 0.5f, message.posZ + 0.25f + level.random.nextFloat() * 0.5f, level.random.nextGaussian() * (double)0.02f, level.random.nextGaussian() * (double)0.02f, level.random.nextGaussian() * (double)0.02f, color, level.random.nextFloat() * 2.0f + 1.0f, 25, 0.0f, false, true);
            }
        }),
        FLOWER_GEN_AURA_CREATION((message, level) -> {
            for (int i = level.random.nextInt(10) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + level.random.nextFloat() * 0.5f, message.posY + 1.01f, message.posZ + 0.25f + level.random.nextFloat() * 0.5f, level.random.nextGaussian() * (double)0.01f, level.random.nextFloat() * 0.04f + 0.02f, level.random.nextGaussian() * (double)0.01f, 6081584, 1.0f + level.random.nextFloat() * 1.5f, 40, 0.0f, false, true);
            }
        }),
        PLACER_PLACING((message, level) -> {
            for (int i = level.random.nextInt(20) + 20; i >= 0; --i) {
                float x;
                boolean side = level.random.nextBoolean();
                float f = side ? level.random.nextFloat() : (x = level.random.nextBoolean() ? 1.1f : -0.1f);
                float z = !side ? level.random.nextFloat() : (level.random.nextBoolean() ? 1.1f : -0.1f);
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + x, message.posY + 0.1f + level.random.nextFloat() * 0.98f, message.posZ + z, 0.0, 0.0, 0.0, 11369015, level.random.nextFloat() + 1.0f, 50, 0.0f, true, true);
            }
        }),
        HOPPER_UPGRADE((message, level) -> {
            for (int i = level.random.nextInt(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.45f, message.posZ, level.random.nextGaussian() * (double)0.015f, level.random.nextGaussian() * (double)0.015f, level.random.nextGaussian() * (double)0.015f, 14542847, level.random.nextFloat() + 1.0f, 30, -0.06f, true, true);
            }
        }),
        SHOCKWAVE_CREATOR((message, level) -> {
            for (int i = 0; i < 360; i += 2) {
                double rad = Math.toRadians(i);
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.01f, message.posZ, (float)Math.sin(rad) * 0.65f, 0.0, (float)Math.cos(rad) * 0.65f, 9509639, 3.0f, 10, 0.0f, false, true);
            }
        }),
        OAK_GENERATOR((message, level) -> {
            int i;
            int sapX = message.data[0];
            int sapY = message.data[1];
            int sapZ = message.data[2];
            boolean releaseAura = message.data[3] > 0;
            for (i = level.random.nextInt(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnParticleStream((float)sapX + 0.5f + (float)level.random.nextGaussian() * 3.0f, (float)sapY + 0.5f + level.random.nextFloat() * 4.0f, (float)sapZ + 0.5f + (float)level.random.nextGaussian() * 3.0f, message.posX + 0.5f, message.posY + 0.5f, message.posZ + 0.5f, 0.6f, BiomeColors.getAverageGrassColor((BlockAndTintGetter)level, (BlockPos)new BlockPos(sapX, sapY, sapZ)), 1.5f);
            }
            if (releaseAura) {
                for (i = level.random.nextInt(10) + 10; i >= 0; --i) {
                    NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + level.random.nextFloat() * 0.5f, message.posY + 1.01f, message.posZ + 0.25f + level.random.nextFloat() * 0.5f, level.random.nextGaussian() * (double)0.03f, level.random.nextFloat() * 0.04f + 0.04f, level.random.nextGaussian() * (double)0.03f, 6081584, 1.0f + level.random.nextFloat() * 1.5f, 60, 0.0f, false, true);
                }
            }
        }),
        OFFERING_TABLE((message, level) -> {
            int i;
            int genX = message.data[0];
            int genY = message.data[1];
            int genZ = message.data[2];
            for (i = level.random.nextInt(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.5f, message.posZ, level.random.nextGaussian() * (double)0.02f, level.random.nextFloat() * 0.25f, level.random.nextGaussian() * (double)0.02f, 0xFFADFD, 1.5f, 40, 0.0f, false, true);
            }
            for (i = level.random.nextInt(50) + 30; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((double)((float)genX + 0.5f) + level.random.nextGaussian() * 2.5, (float)genY + 0.1f, (double)((float)genZ + 0.5f) + level.random.nextGaussian() * 2.5, level.random.nextGaussian() * (double)0.01f, level.random.nextFloat() * 0.01f, level.random.nextGaussian() * (double)0.01f, 13886719, 1.5f, 150, 0.0f, false, true);
            }
        }),
        PICKUP_STOPPER((message, level) -> NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.4f, message.posZ, level.random.nextGaussian() * (double)0.005f, level.random.nextFloat() * 0.005f, level.random.nextGaussian() * (double)0.005f, 13381910, 1.5f, 40, 0.0f, false, true)),
        SPAWN_LAMP((message, level) -> {
            for (int i = level.random.nextInt(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.3f + level.random.nextFloat() * 0.4f, message.posY + 0.15f + level.random.nextFloat() * 0.5f, message.posZ + 0.3f + level.random.nextFloat() * 0.4f, 0.0, 0.0, 0.0, 16032066, 1.0f, 30, 0.0f, false, true);
            }
        }),
        ANIMAL_GEN_CREATE((message, level) -> {
            for (int i = level.random.nextInt(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + level.random.nextFloat() * 0.5f, message.posY + 1.01f, message.posZ + 0.25f + level.random.nextFloat() * 0.5f, level.random.nextGaussian() * (double)0.01f, level.random.nextFloat() * 0.04f + 0.02f, level.random.nextGaussian() * (double)0.01f, 13710088, 1.0f + level.random.nextFloat() * 1.5f, 40, 0.0f, false, true);
            }
        }),
        ANIMAL_GEN_CONSUME((message, level) -> {
            int i;
            boolean child = message.data[0] > 0;
            float height = (float)message.data[1] / 10.0f;
            int genX = message.data[2];
            int genY = message.data[3];
            int genZ = message.data[4];
            int n = i = child ? level.random.nextInt(10) + 10 : level.random.nextInt(20) + 20;
            while (i >= 0) {
                NaturesAuraAPI.instance().spawnMagicParticle((double)message.posX + level.random.nextGaussian() * 0.25, (double)(message.posY + height * 0.75f) + level.random.nextGaussian() * 0.25, (double)message.posZ + level.random.nextGaussian() * 0.25, level.random.nextGaussian() * (double)0.01f, level.random.nextFloat() * 0.01f, level.random.nextGaussian() * (double)0.01f, 4388040, level.random.nextFloat() * (child ? 0.5f : 2.0f) + 1.0f, level.random.nextInt(30) + 40, 0.0f, true, true);
                --i;
            }
            NaturesAuraAPI.instance().spawnParticleStream(message.posX, message.posY + height * 0.75f, message.posZ, (float)genX + 0.5f, (float)genY + 0.5f, (float)genZ + 0.5f, 0.15f, 4310260, child ? 1.5f : 3.0f);
        }),
        END_FLOWER_DECAY((message, level) -> {
            int color = message.data[0];
            for (int i = level.random.nextInt(10) + 20; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + level.random.nextFloat(), message.posY + level.random.nextFloat(), message.posZ + level.random.nextFloat(), level.random.nextGaussian() * (double)0.01f, level.random.nextFloat() * 0.01f, level.random.nextGaussian() * (double)0.01f, color, 1.5f, 80, 0.0f, true, true);
            }
        }),
        ANIMAL_SPAWNER((message, level) -> {
            for (int i = level.random.nextInt(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.5f, message.posZ, level.random.nextGaussian() * (double)0.02f, level.random.nextFloat() * 0.02f, level.random.nextGaussian() * (double)0.02f, 1488818, 1.5f, 40, 0.0f, false, true);
            }
        }),
        RF_CONVERTER((message, level) -> {
            for (int i = level.random.nextInt(5) + 2; i >= 0; --i) {
                Multiblocks.RF_CONVERTER.forEach(BlockPos.containing((double)message.posX, (double)message.posY, (double)message.posZ), 'R', (blockPos, matcher) -> {
                    if (level.random.nextFloat() < 0.35f) {
                        NaturesAuraAPI.instance().spawnParticleStream((float)blockPos.getX() + level.random.nextFloat(), (float)blockPos.getY() + level.random.nextFloat(), (float)blockPos.getZ() + level.random.nextFloat(), message.posX + level.random.nextFloat(), message.posY + level.random.nextFloat(), message.posZ + level.random.nextFloat(), 0.05f, 16718341, 1.5f);
                    }
                    return true;
                });
            }
        }),
        END_FLOWER_CONSUME((message, level) -> {
            int color = message.data[0];
            for (int i = level.random.nextInt(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX, message.posY + 0.5f, message.posZ, level.random.nextGaussian() * (double)0.01f, level.random.nextFloat() * 0.01f, level.random.nextGaussian() * (double)0.01f, color, 1.5f, 40, 0.0f, false, true);
            }
        }),
        MOVER_CART((message, level) -> {
            float motionX = (float)message.data[0] / 100.0f;
            float motionY = (float)message.data[1] / 100.0f;
            float motionZ = (float)message.data[2] / 100.0f;
            for (int i = level.random.nextInt(60) + 30; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((double)message.posX + level.random.nextGaussian() * 10.0, (double)message.posY + level.random.nextGaussian() * 10.0, (double)message.posZ + level.random.nextGaussian() * 10.0, motionX * 0.2f, motionY * 0.2f, motionZ * 0.2f, IAuraType.forLevel(level).getColor(), 2.0f, 30, 0.0f, false, true);
            }
        }),
        MOSS_GENERATOR((message, level) -> {
            int i;
            for (i = level.random.nextInt(30) + 30; i >= 0; --i) {
                float y;
                float x;
                int side = level.random.nextInt(3);
                float f = side != 0 ? level.random.nextFloat() : (x = level.random.nextBoolean() ? 1.1f : -0.1f);
                float f2 = side != 1 ? level.random.nextFloat() : (y = level.random.nextBoolean() ? 1.1f : -0.1f);
                float z = side != 2 ? level.random.nextFloat() : (level.random.nextBoolean() ? 1.1f : -0.1f);
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + x, message.posY + y, message.posZ + z, 0.0, 0.0, 0.0, 1592333, level.random.nextFloat() + 1.0f, 30, 0.0f, true, true);
            }
            for (i = level.random.nextInt(20) + 10; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + level.random.nextFloat(), message.posY + 1.0f, message.posZ + level.random.nextFloat(), level.random.nextGaussian() * (double)0.01f, level.random.nextFloat() * 0.04f + 0.02f, level.random.nextGaussian() * (double)0.01f, 6081584, 1.0f + level.random.nextFloat() * 1.5f, 40, 0.0f, true, true);
            }
        }),
        FIREWORK_GEN((message, level) -> {
            int goalX = message.data[0];
            int goalY = message.data[1];
            int goalZ = message.data[2];
            NaturesAuraAPI.instance().setParticleSpawnRange(64);
            for (int i = level.random.nextInt(30) + 30; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnParticleStream(message.posX + (float)level.random.nextGaussian(), message.posY + (float)level.random.nextGaussian(), message.posZ + (float)level.random.nextGaussian(), (float)goalX + 0.25f + level.random.nextFloat() * 0.5f, (float)goalY + 0.25f + level.random.nextFloat() * 0.5f, (float)goalZ + 0.25f + level.random.nextFloat() * 0.5f, 0.65f, message.data[3 + level.random.nextInt(message.data.length - 3)], 1.0f);
            }
            NaturesAuraAPI.instance().setParticleSpawnRange(32);
        }),
        DIMENSION_RAIL((message, level) -> {
            float width = (float)message.data[0] / 100.0f;
            float height = (float)message.data[1] / 100.0f;
            float depth = (float)message.data[2] / 100.0f;
            for (int i = level.random.nextInt(100) + 50; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + level.random.nextFloat() * width, message.posY + level.random.nextFloat() * height, message.posZ + level.random.nextFloat() * depth, 0.0, 0.0, 0.0, 14028031, 1.0f + level.random.nextFloat(), 60, 0.0f, false, true);
            }
        }),
        PROJECTILE_GEN((message, level) -> {
            int i;
            int x = message.data[0];
            int y = message.data[1];
            int z = message.data[2];
            for (i = level.random.nextInt(10) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((float)x + 0.25f + level.random.nextFloat() * 0.5f, (float)y + 1.01f, (float)z + 0.25f + level.random.nextFloat() * 0.5f, level.random.nextGaussian() * (double)0.01f, level.random.nextFloat() * 0.04f + 0.02f, level.random.nextGaussian() * (double)0.01f, 6081584, 1.0f + level.random.nextFloat() * 1.5f, 40, 0.0f, false, true);
            }
            for (i = level.random.nextInt(10) + 10; i >= 0; --i) {
                level.addParticle((ParticleOptions)ParticleTypes.FIREWORK, (double)message.posX, (double)message.posY, (double)message.posZ, level.random.nextGaussian() * (double)0.03f, level.random.nextGaussian() * (double)0.03f, level.random.nextGaussian() * (double)0.03f);
            }
        }),
        BLAST_FURNACE_BOOSTER((message, level) -> {
            boolean worked = message.data[0] > 0;
            for (int i = level.random.nextInt(10) + 5; i >= 0; --i) {
                level.addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, (double)(message.posX + 0.3125f + (float)level.random.nextInt(6) / 16.0f), (double)(message.posY + 0.6f), (double)(message.posZ + 0.3125f + (float)level.random.nextInt(6) / 16.0f), level.random.nextGaussian() * (double)0.005f, (double)(level.random.nextFloat() * 0.02f + 0.01f), level.random.nextGaussian() * (double)0.005f);
            }
            if (worked) {
                BlockPos pos = BlockPos.containing((double)message.posX, (double)message.posY, (double)message.posZ);
                int color = IAuraChunk.getAuraChunk(level, pos).getType().getColor();
                for (int i = level.random.nextInt(10) + 10; i >= 0; --i) {
                    NaturesAuraAPI.instance().spawnParticleStream(message.posX + (float)level.random.nextGaussian() * 5.0f, message.posY + level.random.nextFloat() * 5.0f, message.posZ + (float)level.random.nextGaussian() * 5.0f, message.posX + 0.5f, message.posY + 0.5f, message.posZ + 0.5f, 0.25f, color, 0.5f + level.random.nextFloat());
                }
            }
        }),
        ANIMAL_CONTAINER((message, level) -> {
            for (int i = level.random.nextInt(2) + 1; i > 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((double)message.posX + level.random.nextGaussian() * (double)0.15f, message.posY - level.random.nextFloat() * 0.5f, (double)message.posZ + level.random.nextGaussian() * (double)0.15f, 0.0, 0.0, 0.0, 4385269, 1.0f + level.random.nextFloat() * 2.0f, 40, 0.0f, false, true);
            }
        }),
        SNOW_CREATOR((message, level) -> {
            BlockPos pos = BlockPos.containing((double)message.posX, (double)message.posY, (double)message.posZ);
            int color = IAuraChunk.getAuraChunk(level, pos).getType().getColor();
            for (int i = level.random.nextInt(3) + 1; i > 0; --i) {
                NaturesAuraAPI.instance().spawnParticleStream(message.posX + (float)level.random.nextGaussian() * 5.0f, message.posY + level.random.nextFloat() * 5.0f, message.posZ + (float)level.random.nextGaussian() * 5.0f, message.posX + 0.5f, message.posY + 0.5f, message.posZ + 0.5f, 0.25f, color, 0.5f + level.random.nextFloat());
            }
        }),
        CHORUS_GENERATOR((message, level) -> {
            int i;
            int chorusX = message.data[0];
            int chorusY = message.data[1];
            int chorusZ = message.data[2];
            for (i = level.random.nextInt(5) + 3; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle((float)chorusX + level.random.nextFloat(), (float)chorusY + level.random.nextFloat(), (float)chorusZ + level.random.nextFloat(), 0.0, 0.0, 0.0, 12258275, 1.0f + level.random.nextFloat(), 50, 0.0f, false, true);
            }
            for (i = level.random.nextInt(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + level.random.nextFloat() * 0.5f, message.posY + 1.01f, message.posZ + 0.25f + level.random.nextFloat() * 0.5f, level.random.nextGaussian() * (double)0.01f, level.random.nextFloat() * 0.04f + 0.02f, level.random.nextGaussian() * (double)0.01f, IAuraType.forLevel(level).getColor(), 1.0f + level.random.nextFloat() * 1.5f, 40, 0.0f, false, true);
            }
        }),
        TIMER_RESET((message, level) -> {
            int color = message.data[0];
            for (int i = level.random.nextInt(10) + 15; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.3125f + level.random.nextFloat() * 6.0f / 16.0f, message.posY + 0.125f + level.random.nextFloat() * 8.0f / 16.0f, message.posZ + 0.3125f + level.random.nextFloat() * 6.0f / 16.0f, 0.0, 0.0, 0.0, color, 2.0f, 40 + level.random.nextInt(20), 0.0f, false, true);
            }
        }),
        STRUCTURE_FINDER((message, level) -> {
            EntityStructureFinder entity = (EntityStructureFinder)level.getEntity(message.data[0]);
            LevelRenderer renderer = Minecraft.getInstance().levelRenderer;
            double d0 = (double)message.posX + 0.5;
            double d13 = message.posY;
            double d18 = (double)message.posZ + 0.5;
            for (int j2 = 0; j2 < 8; ++j2) {
                renderer.addParticle((ParticleOptions)new ItemParticleOption(ParticleTypes.ITEM, entity.getItem()), false, d0, d13, d18, level.random.nextGaussian() * 0.15, level.random.nextDouble() * 0.2, level.random.nextGaussian() * 0.15);
            }
            int color = (Integer)entity.getEntityData().get(EntityStructureFinder.COLOR);
            for (double d24 = 0.0; d24 < Math.PI * 2; d24 += 0.15707963267948966) {
                NaturesAuraAPI.instance().spawnMagicParticle(d0 + Math.cos(d24) * 5.0, d13 - 0.4, d18 + Math.sin(d24) * 5.0, Math.cos(d24) * -2.0, 0.0, Math.sin(d24) * -2.0, color, 2.0f, 60, 0.0f, false, true);
                NaturesAuraAPI.instance().spawnMagicParticle(d0 + Math.cos(d24) * 5.0, d13 - 0.4, d18 + Math.sin(d24) * 5.0, Math.cos(d24) * -2.5, 0.0, Math.sin(d24) * -2.5, color, 2.0f, 60, 0.0f, false, true);
            }
        }),
        SLIME_SPLIT_GEN_CREATE((message, level) -> {
            for (int i = level.random.nextInt(5) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + 0.25f + level.random.nextFloat() * 0.5f, message.posY + 1.01f, message.posZ + 0.25f + level.random.nextFloat() * 0.5f, level.random.nextGaussian() * (double)0.01f, level.random.nextFloat() * 0.04f + 0.02f, level.random.nextGaussian() * (double)0.01f, message.data[0], 1.0f + level.random.nextFloat() * 1.5f, 40, 0.0f, false, true);
            }
        }),
        SLIME_SPLIT_GEN_START((message, level) -> {
            int i;
            int x = message.data[0];
            int y = message.data[1];
            int z = message.data[2];
            int color = message.data[3];
            for (i = level.random.nextInt(10) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + (float)level.random.nextGaussian() * 0.5f, message.posY + (float)level.random.nextGaussian() * 0.5f, message.posZ + (float)level.random.nextGaussian() * 0.5f, level.random.nextGaussian() * (double)0.02f, level.random.nextFloat() * 0.04f + 0.02f, level.random.nextGaussian() * (double)0.02f, color, level.random.nextFloat() + 1.0f, level.random.nextInt(20) + 20, 0.0f, false, true);
            }
            for (i = level.random.nextInt(10) + 5; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnParticleStream(message.posX + (float)level.random.nextGaussian() * 0.5f, message.posY + (float)level.random.nextGaussian() * 0.5f, message.posZ + (float)level.random.nextGaussian() * 0.5f, (float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f, 0.2f, color, level.random.nextFloat() + 1.0f);
            }
        }),
        PET_REVIVER((message, level) -> {
            for (int i = level.random.nextInt(50) + 150; i >= 0; --i) {
                NaturesAuraAPI.instance().spawnMagicParticle(message.posX + (float)level.random.nextGaussian() * 0.4f, message.posY + (float)level.random.nextGaussian() * 0.4f, message.posZ + (float)level.random.nextGaussian() * 0.4f, level.random.nextGaussian() * (double)0.002f, level.random.nextFloat() * 0.001f + 0.002f, level.random.nextGaussian() * (double)0.002f, message.data[0], level.random.nextFloat() * 2.0f + 1.0f, level.random.nextInt(50) + 50, 0.0f, false, true);
            }
        });

        public final BiConsumer<PacketParticles, Level> action;

        private Type(BiConsumer<PacketParticles, Level> action) {
            this.action = action;
        }
    }
}

