/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.proxy;

import de.ellpeck.naturesaura.Helper;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import de.ellpeck.naturesaura.compat.Compat;
import de.ellpeck.naturesaura.entities.ModEntities;
import de.ellpeck.naturesaura.entities.render.RenderEffectInhibitor;
import de.ellpeck.naturesaura.entities.render.RenderMoverMinecart;
import de.ellpeck.naturesaura.entities.render.RenderStub;
import de.ellpeck.naturesaura.events.ClientEvents;
import de.ellpeck.naturesaura.gui.GuiEnderCrate;
import de.ellpeck.naturesaura.gui.ModContainers;
import de.ellpeck.naturesaura.items.ItemColorChanger;
import de.ellpeck.naturesaura.items.ModItems;
import de.ellpeck.naturesaura.particles.ParticleHandler;
import de.ellpeck.naturesaura.particles.ParticleMagic;
import de.ellpeck.naturesaura.proxy.IProxy;
import de.ellpeck.naturesaura.reg.IColorProvidingBlock;
import de.ellpeck.naturesaura.reg.IColorProvidingItem;
import de.ellpeck.naturesaura.reg.IModItem;
import de.ellpeck.naturesaura.reg.ITESRProvider;
import de.ellpeck.naturesaura.reg.ModRegistry;
import de.ellpeck.naturesaura.renderers.PlayerLayerTrinkets;
import de.ellpeck.naturesaura.renderers.SupporterFancyHandler;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.client.color.item.ItemColors;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.ThrownItemRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.NeoForge;

public class ClientProxy
implements IProxy {
    @Override
    public void preInit(FMLCommonSetupEvent event) {
        NeoForge.EVENT_BUS.register((Object)new ClientEvents());
        Compat.setupClient();
        MenuScreens.register(ModContainers.ENDER_CRATE, GuiEnderCrate::new);
        MenuScreens.register(ModContainers.ENDER_ACCESS, GuiEnderCrate::new);
        ItemProperties.register((Item)ModItems.COLOR_CHANGER, (ResourceLocation)new ResourceLocation("naturesaura", "fill_mode"), (stack, level, entity, i) -> ItemColorChanger.isFillMode(stack) ? 1.0f : 0.0f);
        ItemProperties.register((Item)ModItems.COLOR_CHANGER, (ResourceLocation)new ResourceLocation("naturesaura", "has_color"), (stack, level, entity, i) -> ItemColorChanger.getStoredColor(stack) != null ? 1.0f : 0.0f);
        for (Item item : new Item[]{ModItems.SKY_AXE, ModItems.DEPTH_PICKAXE, ModItems.DEPTH_AXE}) {
            ItemProperties.register((Item)item, (ResourceLocation)new ResourceLocation("naturesaura", "enabled"), (stack, level, entity, i) -> Helper.isToolEnabled(stack) ? 1.0f : 0.0f);
        }
    }

    @Override
    public void init(FMLCommonSetupEvent event) {
        Map skinMap = Minecraft.getInstance().getEntityRenderDispatcher().getSkinMap();
        for (EntityRenderer render : new EntityRenderer[]{(EntityRenderer)skinMap.get("default"), (EntityRenderer)skinMap.get("slim")}) {
            if (!(render instanceof PlayerRenderer)) continue;
            PlayerRenderer living = (PlayerRenderer)render;
            living.addLayer((RenderLayer)new PlayerLayerTrinkets((RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>>)living));
        }
        new SupporterFancyHandler();
        for (IModItem item : ModRegistry.ALL_ITEMS) {
            if (item instanceof IColorProvidingBlock) {
                IColorProvidingBlock color = (IColorProvidingBlock)((Object)item);
                this.addColorProvidingBlock(color);
            }
            if (item instanceof IColorProvidingItem) {
                IColorProvidingItem color = (IColorProvidingItem)((Object)item);
                this.addColorProvidingItem(color);
            }
            if (!(item instanceof ITESRProvider)) continue;
            ITESRProvider provider = (ITESRProvider)((Object)item);
            provider.registerTESR();
        }
        EntityRenderers.register(ModEntities.MOVER_CART, RenderMoverMinecart::new);
        EntityRenderers.register(ModEntities.EFFECT_INHIBITOR, RenderEffectInhibitor::new);
        EntityRenderers.register(ModEntities.LIGHT_PROJECTILE, RenderStub::new);
        EntityRenderers.register(ModEntities.STRUCTURE_FINDER, c -> new ThrownItemRenderer(c, 1.0f, true));
    }

    @Override
    public void postInit(FMLCommonSetupEvent event) {
        ItemBlockRenderTypes.setRenderLayer((Block)ModBlocks.GOLD_POWDER, (RenderType)RenderType.cutoutMipped());
    }

    @Override
    public void spawnMagicParticle(double posX, double posY, double posZ, double motionX, double motionY, double motionZ, int color, float scale, int maxAge, float gravity, boolean collision, boolean fade) {
        ParticleHandler.spawnParticle(() -> new ParticleMagic(Minecraft.getInstance().level, posX, posY, posZ, motionX, motionY, motionZ, color, scale, maxAge, gravity, collision, fade, ParticleHandler.depthEnabled), posX, posY, posZ);
    }

    @Override
    public void setParticleDepth(boolean depth) {
        ParticleHandler.depthEnabled = depth;
    }

    @Override
    public void setParticleSpawnRange(int range) {
        ParticleHandler.range = range;
    }

    @Override
    public void setParticleCulling(boolean cull) {
        ParticleHandler.culling = cull;
    }

    private void addColorProvidingItem(IColorProvidingItem item) {
        ItemColors colors = Minecraft.getInstance().getItemColors();
        ItemColor color = item.getItemColor();
        if (item instanceof Item) {
            colors.register(color, new ItemLike[]{(Item)item});
        } else if (item instanceof Block) {
            colors.register(color, new ItemLike[]{(Block)item});
        }
    }

    private void addColorProvidingBlock(IColorProvidingBlock block) {
        if (block instanceof Block) {
            Minecraft.getInstance().getBlockColors().register(block.getBlockColor(), new Block[]{(Block)block});
        }
    }
}

