/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.naturesaura.recipes.ModRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;

public class AnimalSpawnerRecipe
extends ModRecipe {
    public final List<Ingredient> ingredients;
    public final EntityType<?> entity;
    public final int aura;
    public final int time;

    public AnimalSpawnerRecipe(ResourceLocation entityType, int aura, int time, List<Ingredient> ingredients) {
        this.ingredients = ingredients;
        this.entity = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(entityType);
        this.aura = aura;
        this.time = time;
    }

    public Entity makeEntity(Level level, BlockPos pos) {
        if (pos == BlockPos.ZERO) {
            return this.entity.create(level);
        }
        return this.entity.create((ServerLevel)level, null, null, pos, MobSpawnType.SPAWNER, false, false);
    }

    public ItemStack getResultItem(RegistryAccess access) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.ANIMAL_SPAWNER_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return ModRecipes.ANIMAL_SPAWNER_TYPE;
    }

    public static class Serializer
    implements RecipeSerializer<AnimalSpawnerRecipe> {
        private static final Codec<AnimalSpawnerRecipe> CODEC = RecordCodecBuilder.create(i -> i.group((App)ResourceLocation.CODEC.fieldOf("entity").forGetter(r -> BuiltInRegistries.ENTITY_TYPE.getKey(r.entity)), (App)Codec.INT.fieldOf("aura").forGetter(r -> r.aura), (App)Codec.INT.fieldOf("time").forGetter(r -> r.time), (App)Ingredient.CODEC.listOf().fieldOf("ingredients").forGetter(r -> r.ingredients)).apply((Applicative)i, AnimalSpawnerRecipe::new));

        public Codec<AnimalSpawnerRecipe> codec() {
            return CODEC;
        }

        public AnimalSpawnerRecipe fromNetwork(FriendlyByteBuf buffer) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (int i = buffer.readInt(); i > 0; --i) {
                ingredients.add(Ingredient.fromNetwork((FriendlyByteBuf)buffer));
            }
            return new AnimalSpawnerRecipe(buffer.readResourceLocation(), buffer.readInt(), buffer.readInt(), ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, AnimalSpawnerRecipe recipe) {
            buffer.writeInt(recipe.ingredients.size());
            for (Ingredient ing : recipe.ingredients) {
                ing.toNetwork(buffer);
            }
            buffer.writeResourceLocation(BuiltInRegistries.ENTITY_TYPE.getKey(recipe.entity));
            buffer.writeInt(recipe.aura);
            buffer.writeInt(recipe.time);
        }
    }
}

