/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.naturesaura.recipes.ModRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class OfferingRecipe
extends ModRecipe {
    public final Ingredient input;
    public final Ingredient startItem;
    public final ItemStack output;

    public OfferingRecipe(Ingredient input, Ingredient startItem, ItemStack output) {
        this.input = input;
        this.startItem = startItem;
        this.output = output;
    }

    public ItemStack getResultItem(RegistryAccess access) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.OFFERING_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return ModRecipes.OFFERING_TYPE;
    }

    public static class Serializer
    implements RecipeSerializer<OfferingRecipe> {
        private static final Codec<OfferingRecipe> CODEC = RecordCodecBuilder.create(i -> i.group((App)Ingredient.CODEC.fieldOf("input").forGetter(r -> r.input), (App)Ingredient.CODEC.fieldOf("start_item").forGetter(r -> r.startItem), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("output").forGetter(r -> r.output)).apply((Applicative)i, OfferingRecipe::new));

        public Codec<OfferingRecipe> codec() {
            return CODEC;
        }

        @Nullable
        public OfferingRecipe fromNetwork(FriendlyByteBuf buffer) {
            return new OfferingRecipe(Ingredient.fromNetwork((FriendlyByteBuf)buffer), Ingredient.fromNetwork((FriendlyByteBuf)buffer), buffer.readItem());
        }

        public void toNetwork(FriendlyByteBuf buffer, OfferingRecipe recipe) {
            recipe.input.toNetwork(buffer);
            recipe.startItem.toNetwork(buffer);
            buffer.writeItem(recipe.output);
        }
    }
}

