/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.naturesaura.recipes;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.ellpeck.naturesaura.recipes.ModRecipe;
import de.ellpeck.naturesaura.recipes.ModRecipes;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;

public class TreeRitualRecipe
extends ModRecipe {
    public final Ingredient saplingType;
    public final List<Ingredient> ingredients;
    public final ItemStack output;
    public final int time;

    public TreeRitualRecipe(Ingredient saplingType, ItemStack output, int time, List<Ingredient> ingredients) {
        this.saplingType = saplingType;
        this.ingredients = ingredients;
        this.output = output;
        this.time = time;
    }

    public ItemStack getResultItem(RegistryAccess access) {
        return this.output;
    }

    public RecipeSerializer<?> getSerializer() {
        return ModRecipes.TREE_RITUAL_SERIALIZER;
    }

    public RecipeType<?> getType() {
        return ModRecipes.TREE_RITUAL_TYPE;
    }

    public static class Serializer
    implements RecipeSerializer<TreeRitualRecipe> {
        private static final Codec<TreeRitualRecipe> CODEC = RecordCodecBuilder.create(i -> i.group((App)Ingredient.CODEC.fieldOf("sapling").forGetter(r -> r.saplingType), (App)ItemStack.ITEM_WITH_COUNT_CODEC.fieldOf("output").forGetter(r -> r.output), (App)Codec.INT.fieldOf("time").forGetter(r -> r.time), (App)Ingredient.CODEC.listOf().fieldOf("ingredients").forGetter(recipe -> recipe.ingredients)).apply((Applicative)i, TreeRitualRecipe::new));

        public Codec<TreeRitualRecipe> codec() {
            return CODEC;
        }

        @Nullable
        public TreeRitualRecipe fromNetwork(FriendlyByteBuf buffer) {
            ArrayList<Ingredient> ingredients = new ArrayList<Ingredient>();
            for (int i = buffer.readInt(); i > 0; --i) {
                ingredients.add(Ingredient.fromNetwork((FriendlyByteBuf)buffer));
            }
            return new TreeRitualRecipe(Ingredient.fromNetwork((FriendlyByteBuf)buffer), buffer.readItem(), buffer.readInt(), ingredients);
        }

        public void toNetwork(FriendlyByteBuf buffer, TreeRitualRecipe recipe) {
            buffer.writeInt(recipe.ingredients.size());
            for (Ingredient ing : recipe.ingredients) {
                ing.toNetwork(buffer);
            }
            recipe.saplingType.toNetwork(buffer);
            buffer.writeItem(recipe.output);
            buffer.writeInt(recipe.time);
        }
    }
}

