/*
 * Decompiled with CFR 0.152.
 */
package vazkii.neat;

import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_809;
import org.joml.Quaternionf;
import vazkii.neat.NeatConfig;
import vazkii.neat.NeatRenderType;

public class HealthBarRenderer {
    private static final DecimalFormat HEALTH_FORMAT = new DecimalFormat("#.##");

    @Nullable
    private static class_1297 getEntityLookedAt(class_1297 e) {
        class_1297 foundEntity = null;
        double finalDistance = 32.0;
        class_239 pos = HealthBarRenderer.raycast(e, 32.0);
        class_243 positionVector = e.method_33571();
        double distance = pos.method_17784().method_1022(positionVector);
        class_243 lookVector = e.method_5720();
        class_243 reachVector = positionVector.method_1031(lookVector.field_1352 * 32.0, lookVector.field_1351 * 32.0, lookVector.field_1350 * 32.0);
        List entitiesInBoundingBox = e.method_37908().method_8335(e, e.method_5829().method_1009(lookVector.field_1352 * 32.0, lookVector.field_1351 * 32.0, lookVector.field_1350 * 32.0).method_1012(1.0, 1.0, 1.0));
        double minDistance = distance;
        for (class_1297 entity : entitiesInBoundingBox) {
            class_1297 lookedEntity = null;
            if (entity.method_5863()) {
                double distanceToEntity;
                class_238 collisionBox = entity.method_5830();
                Optional interceptPosition = collisionBox.method_992(positionVector, reachVector);
                if (collisionBox.method_1006(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition.isPresent() && ((distanceToEntity = positionVector.method_1022((class_243)interceptPosition.get())) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance)) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    private static class_239 raycast(class_1297 e, double len) {
        return HealthBarRenderer.raycast(e.method_33571(), e.method_5720(), e, len);
    }

    private static class_239 raycast(class_243 origin, class_243 ray, class_1297 e, double len) {
        class_243 next = origin.method_1019(ray.method_1029().method_1021(len));
        return e.field_6002.method_17742(new class_3959(origin, next, class_3959.class_3960.field_17559, class_3959.class_242.field_1348, e));
    }

    @Nonnull
    private static class_1799 getIcon(class_1309 entity, boolean boss) {
        if (boss) {
            return new class_1799((class_1935)class_1802.field_8137);
        }
        class_1310 type = entity.method_6046();
        if (type == class_1310.field_6293) {
            return new class_1799((class_1935)class_1802.field_8680);
        }
        if (type == class_1310.field_6289) {
            return new class_1799((class_1935)class_1802.field_8511);
        }
        return class_1799.field_8037;
    }

    private static int getColor(class_1309 entity, boolean colorByType, boolean boss) {
        if (colorByType) {
            int r = 0;
            int g = 255;
            int b = 0;
            if (boss) {
                r = 128;
                g = 0;
                b = 128;
            }
            if (entity instanceof class_1588) {
                r = 255;
                g = 0;
                b = 0;
            }
            return 0xFF000000 | r << 16 | g << 8 | b;
        }
        float health = class_3532.method_15363((float)entity.method_6032(), (float)0.0f, (float)entity.method_6063());
        float hue = Math.max(0.0f, health / entity.method_6063() / 3.0f - 0.07f);
        return class_3532.method_15369((float)hue, (float)1.0f, (float)1.0f);
    }

    private static boolean isBoss(class_1297 entity) {
        return !entity.method_5822();
    }

    private static boolean shouldShowPlate(class_1297 entity, class_1297 cameraEntity) {
        if (!NeatConfig.instance.renderInF1() && !class_310.method_1498() || !NeatConfig.draw) {
            return false;
        }
        if (!(entity instanceof class_1309)) {
            return false;
        }
        class_1309 living = (class_1309)entity;
        class_2960 id = class_7923.field_41177.method_10221((Object)living.method_5864());
        if (NeatConfig.instance.blacklist().contains(id.toString())) {
            return false;
        }
        float distance = living.method_5739(cameraEntity);
        if (distance > (float)NeatConfig.instance.maxDistance() || !living.method_6057(cameraEntity) || living.method_5767()) {
            return false;
        }
        if (!NeatConfig.instance.showOnBosses() && HealthBarRenderer.isBoss((class_1297)living)) {
            return false;
        }
        if (!NeatConfig.instance.showOnPlayers() && living instanceof class_1657) {
            return false;
        }
        if (!NeatConfig.instance.showFullHealth() && living.method_6032() >= living.method_6063()) {
            return false;
        }
        return !NeatConfig.instance.showOnlyFocused() || HealthBarRenderer.getEntityLookedAt(cameraEntity) == entity;
    }

    public static void hookRender(class_1297 entity, class_4587 poseStack, class_4597 buffers, Quaternionf cameraOrientation) {
        int armor;
        class_1309 living;
        class_310 mc;
        block16: {
            block15: {
                mc = class_310.method_1551();
                if (!(entity instanceof class_1309)) break block15;
                living = (class_1309)entity;
                if (entity.method_5685().isEmpty()) break block16;
            }
            return;
        }
        if (!HealthBarRenderer.shouldShowPlate(entity, mc.field_1773.method_19418().method_19331())) {
            return;
        }
        int light = 0xF000F0;
        float globalScale = 0.0267f;
        float textScale = 0.5f;
        int barHeight = NeatConfig.instance.barHeight();
        boolean boss = HealthBarRenderer.isBoss(entity);
        String name = entity.method_16914() ? class_124.field_1056 + entity.method_5797().getString() : entity.method_5476().getString();
        float nameLen = (float)mc.field_1772.method_1727(name) * 0.5f;
        float halfSize = Math.max((float)NeatConfig.instance.plateSize(), nameLen / 2.0f + 10.0f);
        poseStack.method_22903();
        poseStack.method_22904(0.0, (double)entity.method_17682() + NeatConfig.instance.heightAbove(), 0.0);
        poseStack.method_22907(cameraOrientation);
        poseStack.method_22903();
        poseStack.method_22905(-0.0267f, -0.0267f, 0.0267f);
        if (NeatConfig.instance.drawBackground()) {
            float padding = NeatConfig.instance.backgroundPadding();
            int bgHeight = NeatConfig.instance.backgroundHeight();
            class_4588 builder = buffers.getBuffer(NeatRenderType.BAR_TEXTURE_TYPE);
            builder.method_22918(poseStack.method_23760().method_23761(), -halfSize - padding, (float)(-bgHeight), 0.01f).method_1336(0, 0, 0, 64).method_22913(0.0f, 0.0f).method_22916(0xF000F0).method_1344();
            builder.method_22918(poseStack.method_23760().method_23761(), -halfSize - padding, (float)barHeight + padding, 0.01f).method_1336(0, 0, 0, 64).method_22913(0.0f, 0.5f).method_22916(0xF000F0).method_1344();
            builder.method_22918(poseStack.method_23760().method_23761(), halfSize + padding, (float)barHeight + padding, 0.01f).method_1336(0, 0, 0, 64).method_22913(1.0f, 0.5f).method_22916(0xF000F0).method_1344();
            builder.method_22918(poseStack.method_23760().method_23761(), halfSize + padding, (float)(-bgHeight), 0.01f).method_1336(0, 0, 0, 64).method_22913(1.0f, 0.0f).method_22916(0xF000F0).method_1344();
        }
        int argb = HealthBarRenderer.getColor(living, NeatConfig.instance.colorByType(), boss);
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        float maxHealth = Math.max(living.method_6032(), living.method_6063());
        float healthHalfSize = halfSize * (living.method_6032() / maxHealth);
        class_4588 builder = buffers.getBuffer(NeatRenderType.BAR_TEXTURE_TYPE);
        builder.method_22918(poseStack.method_23760().method_23761(), -halfSize, 0.0f, 0.001f).method_1336(r, g, b, 127).method_22913(0.0f, 0.75f).method_22916(0xF000F0).method_1344();
        builder.method_22918(poseStack.method_23760().method_23761(), -halfSize, (float)barHeight, 0.001f).method_1336(r, g, b, 127).method_22913(0.0f, 1.0f).method_22916(0xF000F0).method_1344();
        builder.method_22918(poseStack.method_23760().method_23761(), -halfSize + 2.0f * healthHalfSize, (float)barHeight, 0.001f).method_1336(r, g, b, 127).method_22913(1.0f, 1.0f).method_22916(0xF000F0).method_1344();
        builder.method_22918(poseStack.method_23760().method_23761(), -halfSize + 2.0f * healthHalfSize, 0.0f, 0.001f).method_1336(r, g, b, 127).method_22913(1.0f, 0.75f).method_22916(0xF000F0).method_1344();
        if (healthHalfSize < halfSize) {
            builder.method_22918(poseStack.method_23760().method_23761(), -halfSize + 2.0f * healthHalfSize, 0.0f, 0.001f).method_1336(0, 0, 0, 127).method_22913(0.0f, 0.5f).method_22916(0xF000F0).method_1344();
            builder.method_22918(poseStack.method_23760().method_23761(), -halfSize + 2.0f * healthHalfSize, (float)barHeight, 0.001f).method_1336(0, 0, 0, 127).method_22913(0.0f, 0.75f).method_22916(0xF000F0).method_1344();
            builder.method_22918(poseStack.method_23760().method_23761(), halfSize, (float)barHeight, 0.001f).method_1336(0, 0, 0, 127).method_22913(1.0f, 0.75f).method_22916(0xF000F0).method_1344();
            builder.method_22918(poseStack.method_23760().method_23761(), halfSize, 0.0f, 0.001f).method_1336(0, 0, 0, 127).method_22913(1.0f, 0.5f).method_22916(0xF000F0).method_1344();
        }
        int white = 0xFFFFFF;
        boolean black = false;
        poseStack.method_22903();
        poseStack.method_46416(-halfSize, -4.5f, 0.0f);
        poseStack.method_22905(0.5f, 0.5f, 0.5f);
        mc.field_1772.method_27521(name, 0.0f, 0.0f, 0xFFFFFF, false, poseStack.method_23760().method_23761(), buffers, false, 0, 0xF000F0);
        poseStack.method_22909();
        float healthValueTextScale = 0.375f;
        poseStack.method_22903();
        poseStack.method_46416(-halfSize, -4.5f, 0.0f);
        poseStack.method_22905(0.375f, 0.375f, 0.375f);
        int h = NeatConfig.instance.hpTextHeight();
        if (NeatConfig.instance.showCurrentHP()) {
            String hpStr = HEALTH_FORMAT.format(living.method_6032());
            mc.field_1772.method_27521(hpStr, 2.0f, (float)h, 0xFFFFFF, false, poseStack.method_23760().method_23761(), buffers, false, 0, 0xF000F0);
        }
        if (NeatConfig.instance.showMaxHP()) {
            String maxHpStr = class_124.field_1067 + HEALTH_FORMAT.format(living.method_6063());
            mc.field_1772.method_27521(maxHpStr, (float)((int)(halfSize / 0.375f * 2.0f) - mc.field_1772.method_1727(maxHpStr) - 2), (float)h, 0xFFFFFF, false, poseStack.method_23760().method_23761(), buffers, false, 0, 0xF000F0);
        }
        if (NeatConfig.instance.showPercentage()) {
            String percStr = (int)(100.0f * living.method_6032() / living.method_6063()) + "%";
            mc.field_1772.method_27521(percStr, (float)((int)(halfSize / 0.375f)) - (float)mc.field_1772.method_1727(percStr) / 2.0f, (float)h, 0xFFFFFF, false, poseStack.method_23760().method_23761(), buffers, false, 0, 0xF000F0);
        }
        if (NeatConfig.instance.enableDebugInfo() && mc.field_1690.field_1866) {
            class_2960 id = class_7923.field_41177.method_10221((Object)entity.method_5864());
            mc.field_1772.method_27521("ID: \"" + id + "\"", 0.0f, (float)(h + 16), 0xFFFFFF, false, poseStack.method_23760().method_23761(), buffers, false, 0, 0xF000F0);
        }
        poseStack.method_22909();
        poseStack.method_22909();
        float zBump = -0.1f;
        poseStack.method_22903();
        float iconOffset = 2.85f;
        float zShift = 0.0f;
        if (NeatConfig.instance.showAttributes()) {
            class_1799 icon = HealthBarRenderer.getIcon(living, boss);
            HealthBarRenderer.renderIcon(icon, poseStack, buffers, 0.0267f, halfSize, iconOffset, zShift);
            iconOffset += 5.0f;
            zShift += -0.1f;
        }
        if ((armor = living.method_6096()) > 0 && NeatConfig.instance.showArmor()) {
            int ironArmor = armor % 5;
            int diamondArmor = armor / 5;
            if (!NeatConfig.instance.groupArmor()) {
                ironArmor = armor;
                diamondArmor = 0;
            }
            class_1799 iron = new class_1799((class_1935)class_1802.field_8523);
            for (int i = 0; i < ironArmor; ++i) {
                HealthBarRenderer.renderIcon(iron, poseStack, buffers, 0.0267f, halfSize, iconOffset, zShift);
                iconOffset += 1.0f;
                zShift += -0.1f;
            }
            class_1799 diamond = new class_1799((class_1935)class_1802.field_8058);
            for (int i = 0; i < diamondArmor; ++i) {
                HealthBarRenderer.renderIcon(diamond, poseStack, buffers, 0.0267f, halfSize, iconOffset, zShift);
                iconOffset += 1.0f;
                zShift += -0.1f;
            }
        }
        poseStack.method_22909();
        poseStack.method_22909();
    }

    private static void renderIcon(class_1799 icon, class_4587 poseStack, class_4597 buffers, float globalScale, float halfSize, float leftShift, float zShift) {
        if (!icon.method_7960()) {
            float iconScale = 0.12f;
            poseStack.method_22903();
            float dx = (halfSize - leftShift) * globalScale;
            float dy = 3.0f * globalScale;
            float dz = zShift * globalScale;
            poseStack.method_46416(-dx, dy, dz);
            poseStack.method_22905(0.12f, 0.12f, 0.12f);
            poseStack.method_22907(class_7833.field_40716.rotationDegrees(180.0f));
            class_310.method_1551().method_1480().method_23178(icon, class_809.class_811.field_4315, 0xF000F0, class_4608.field_21444, poseStack, buffers, 0);
            poseStack.method_22909();
        }
    }
}

