/*
 * Decompiled with CFR 0.152.
 */
package vazkii.neat;

import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.FiberSerialization;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.JanksonValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.serialization.ValueSerializer;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import vazkii.neat.NeatConfig;

public final class NeatFiberConfig {
    private static final Logger LOGGER = LogManager.getLogger(NeatFiberConfig.class);
    private static final Client CLIENT = new Client();

    private static void writeDefaultConfig(ConfigTree config, Path path, JanksonValueSerializer serializer) {
        try (BufferedOutputStream s2 = new BufferedOutputStream(Files.newOutputStream(path, StandardOpenOption.WRITE, StandardOpenOption.CREATE_NEW));){
            FiberSerialization.serialize((ConfigTree)config, (OutputStream)s2, (ValueSerializer)serializer);
        }
        catch (FileAlreadyExistsException s2) {
        }
        catch (IOException e) {
            LOGGER.error("Error writing default config", (Throwable)e);
        }
    }

    private static void setupConfig(ConfigTree config, Path p, JanksonValueSerializer serializer) {
        NeatFiberConfig.writeDefaultConfig(config, p, serializer);
        try (BufferedInputStream s = new BufferedInputStream(Files.newInputStream(p, StandardOpenOption.READ, StandardOpenOption.CREATE));){
            FiberSerialization.deserialize((ConfigTree)config, (InputStream)s, (ValueSerializer)serializer);
        }
        catch (ValueDeserializationException | IOException e) {
            LOGGER.error("Error loading config from {}", (Object)p, (Object)e);
        }
    }

    public static void setup() {
        try {
            Files.createDirectory(Paths.get("config", new String[0]), new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            LOGGER.warn("Failed to make config dir", (Throwable)e);
        }
        JanksonValueSerializer serializer = new JanksonValueSerializer(false);
        ConfigTree client = CLIENT.configure(ConfigTree.builder());
        NeatFiberConfig.setupConfig(client, Paths.get("config", "neat-client.json5"), serializer);
        NeatConfig.instance = CLIENT;
    }

    private static class Client
    implements NeatConfig.ConfigAccess {
        private final PropertyMirror<Integer> maxDistance = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        private final PropertyMirror<Boolean> renderInF1 = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<Double> heightAbove = PropertyMirror.create((ConfigType)ConfigTypes.DOUBLE);
        private final PropertyMirror<Boolean> drawBackground = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<Integer> backgroundPadding = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        private final PropertyMirror<Integer> backgroundHeight = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        private final PropertyMirror<Integer> barHeight = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        private final PropertyMirror<Integer> plateSize = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        private final PropertyMirror<Integer> plateSizeBoss = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        private final PropertyMirror<Boolean> showAttributes = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<Boolean> showArmor = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<Boolean> groupArmor = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<Boolean> colorByType = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<Integer> hpTextHeight = PropertyMirror.create((ConfigType)ConfigTypes.INTEGER);
        private final PropertyMirror<Boolean> showMaxHP = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<Boolean> showCurrentHP = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<Boolean> showPercentage = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<Boolean> showOnPlayers = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<Boolean> showOnBosses = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<Boolean> showOnlyFocused = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<Boolean> showFullHealth = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<Boolean> enableDebugInfo = PropertyMirror.create((ConfigType)ConfigTypes.BOOLEAN);
        private final PropertyMirror<List<String>> blacklist = PropertyMirror.create((ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING));

        private Client() {
        }

        public ConfigTree configure(ConfigTreeBuilder builder) {
            builder.beginValue("maxDistance", (ConfigType)ConfigTypes.INTEGER, (Object)24).finishValue(arg_0 -> this.maxDistance.mirror(arg_0)).beginValue("renderInF1", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).finishValue(arg_0 -> this.renderInF1.mirror(arg_0)).beginValue("heightAbove", (ConfigType)ConfigTypes.DOUBLE, (Object)0.6).finishValue(arg_0 -> this.heightAbove.mirror(arg_0)).beginValue("drawBackground", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).finishValue(arg_0 -> this.drawBackground.mirror(arg_0)).beginValue("backgroundPadding", (ConfigType)ConfigTypes.INTEGER, (Object)2).finishValue(arg_0 -> this.backgroundPadding.mirror(arg_0)).beginValue("backgroundHeight", (ConfigType)ConfigTypes.INTEGER, (Object)6).finishValue(arg_0 -> this.backgroundHeight.mirror(arg_0)).beginValue("barHeight", (ConfigType)ConfigTypes.INTEGER, (Object)4).finishValue(arg_0 -> this.barHeight.mirror(arg_0)).beginValue("plateSize", (ConfigType)ConfigTypes.INTEGER, (Object)25).finishValue(arg_0 -> this.plateSize.mirror(arg_0)).beginValue("plateSizeBoss", (ConfigType)ConfigTypes.INTEGER, (Object)50).finishValue(arg_0 -> this.plateSizeBoss.mirror(arg_0)).beginValue("showAttributes", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).finishValue(arg_0 -> this.showAttributes.mirror(arg_0)).beginValue("showArmor", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).finishValue(arg_0 -> this.showArmor.mirror(arg_0)).beginValue("groupArmor", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).finishValue(arg_0 -> this.groupArmor.mirror(arg_0)).beginValue("colorByType", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).finishValue(arg_0 -> this.colorByType.mirror(arg_0)).beginValue("hpTextHeight", (ConfigType)ConfigTypes.INTEGER, (Object)14).finishValue(arg_0 -> this.hpTextHeight.mirror(arg_0)).beginValue("showMaxHP", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).finishValue(arg_0 -> this.showMaxHP.mirror(arg_0)).beginValue("showCurrentHP", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).finishValue(arg_0 -> this.showCurrentHP.mirror(arg_0)).beginValue("showPercentage", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).finishValue(arg_0 -> this.showPercentage.mirror(arg_0)).beginValue("showOnPlayers", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).finishValue(arg_0 -> this.showOnPlayers.mirror(arg_0)).beginValue("showOnBosses", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).finishValue(arg_0 -> this.showOnBosses.mirror(arg_0)).beginValue("showOnlyFocused", (ConfigType)ConfigTypes.BOOLEAN, (Object)false).finishValue(arg_0 -> this.showOnlyFocused.mirror(arg_0)).beginValue("showFullHealth", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).finishValue(arg_0 -> this.showFullHealth.mirror(arg_0)).beginValue("enableDebugInfo", (ConfigType)ConfigTypes.BOOLEAN, (Object)true).finishValue(arg_0 -> this.enableDebugInfo.mirror(arg_0)).beginValue("blacklist", (ConfigType)ConfigTypes.makeList((ConfigType)ConfigTypes.STRING), NeatConfig.DEFAULT_DISABLED).finishValue(arg_0 -> this.blacklist.mirror(arg_0));
            return builder.build();
        }

        @Override
        public int maxDistance() {
            return (Integer)this.maxDistance.getValue();
        }

        @Override
        public boolean renderInF1() {
            return (Boolean)this.renderInF1.getValue();
        }

        @Override
        public double heightAbove() {
            return (Double)this.heightAbove.getValue();
        }

        @Override
        public boolean drawBackground() {
            return (Boolean)this.drawBackground.getValue();
        }

        @Override
        public int backgroundPadding() {
            return (Integer)this.backgroundPadding.getValue();
        }

        @Override
        public int backgroundHeight() {
            return (Integer)this.backgroundHeight.getValue();
        }

        @Override
        public int barHeight() {
            return (Integer)this.barHeight.getValue();
        }

        @Override
        public int plateSize() {
            return (Integer)this.plateSize.getValue();
        }

        @Override
        public int plateSizeBoss() {
            return (Integer)this.plateSizeBoss.getValue();
        }

        @Override
        public boolean showAttributes() {
            return (Boolean)this.showAttributes.getValue();
        }

        @Override
        public boolean showArmor() {
            return (Boolean)this.showArmor.getValue();
        }

        @Override
        public boolean groupArmor() {
            return (Boolean)this.groupArmor.getValue();
        }

        @Override
        public boolean colorByType() {
            return (Boolean)this.colorByType.getValue();
        }

        @Override
        public int hpTextHeight() {
            return (Integer)this.hpTextHeight.getValue();
        }

        @Override
        public boolean showMaxHP() {
            return (Boolean)this.showMaxHP.getValue();
        }

        @Override
        public boolean showCurrentHP() {
            return (Boolean)this.showCurrentHP.getValue();
        }

        @Override
        public boolean showPercentage() {
            return (Boolean)this.showPercentage.getValue();
        }

        @Override
        public boolean showOnPlayers() {
            return (Boolean)this.showOnPlayers.getValue();
        }

        @Override
        public boolean showOnBosses() {
            return (Boolean)this.showOnBosses.getValue();
        }

        @Override
        public boolean showOnlyFocused() {
            return (Boolean)this.showOnlyFocused.getValue();
        }

        @Override
        public boolean showFullHealth() {
            return (Boolean)this.showFullHealth.getValue();
        }

        @Override
        public boolean enableDebugInfo() {
            return (Boolean)this.enableDebugInfo.getValue();
        }

        @Override
        public List<String> blacklist() {
            return (List)this.blacklist.getValue();
        }
    }
}

