/*
 * Decompiled with CFR 0.152.
 */
package vazkii.neat;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;
import vazkii.neat.NeatConfig;
import vazkii.neat.NeatRenderType;

public class HealthBarRenderer {
    private static final DecimalFormat HEALTH_FORMAT = new DecimalFormat("#.##");

    @Nullable
    private static Entity getEntityLookedAt(Entity e) {
        Entity foundEntity = null;
        double finalDistance = 32.0;
        HitResult pos = HealthBarRenderer.raycast(e, 32.0);
        Vec3 positionVector = e.m_146892_();
        double distance = pos.m_82450_().m_82554_(positionVector);
        Vec3 lookVector = e.m_20154_();
        Vec3 reachVector = positionVector.m_82520_(lookVector.f_82479_ * 32.0, lookVector.f_82480_ * 32.0, lookVector.f_82481_ * 32.0);
        List entitiesInBoundingBox = e.m_9236_().m_45933_(e, e.m_20191_().m_82377_(lookVector.f_82479_ * 32.0, lookVector.f_82480_ * 32.0, lookVector.f_82481_ * 32.0).m_82363_(1.0, 1.0, 1.0));
        double minDistance = distance;
        for (Entity entity : entitiesInBoundingBox) {
            Entity lookedEntity = null;
            if (entity.m_6087_()) {
                double distanceToEntity;
                AABB collisionBox = entity.m_6921_();
                Optional interceptPosition = collisionBox.m_82371_(positionVector, reachVector);
                if (collisionBox.m_82390_(positionVector)) {
                    if (0.0 < minDistance || minDistance == 0.0) {
                        lookedEntity = entity;
                        minDistance = 0.0;
                    }
                } else if (interceptPosition.isPresent() && ((distanceToEntity = positionVector.m_82554_((Vec3)interceptPosition.get())) < minDistance || minDistance == 0.0)) {
                    lookedEntity = entity;
                    minDistance = distanceToEntity;
                }
            }
            if (lookedEntity == null || !(minDistance < distance)) continue;
            foundEntity = lookedEntity;
        }
        return foundEntity;
    }

    private static HitResult raycast(Entity e, double len) {
        return HealthBarRenderer.raycast(e.m_146892_(), e.m_20154_(), e, len);
    }

    private static HitResult raycast(Vec3 origin, Vec3 ray, Entity e, double len) {
        Vec3 next = origin.m_82549_(ray.m_82541_().m_82490_(len));
        return e.f_19853_.m_45547_(new ClipContext(origin, next, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, e));
    }

    @Nonnull
    private static ItemStack getIcon(LivingEntity entity, boolean boss) {
        if (boss) {
            return new ItemStack((ItemLike)Items.f_42686_);
        }
        MobType type = entity.m_6336_();
        if (type == MobType.f_21642_) {
            return new ItemStack((ItemLike)Items.f_42591_);
        }
        if (type == MobType.f_21641_) {
            return new ItemStack((ItemLike)Items.f_42583_);
        }
        return ItemStack.f_41583_;
    }

    private static int getColor(LivingEntity entity, boolean colorByType, boolean boss) {
        if (colorByType) {
            int r = 0;
            int g = 255;
            int b = 0;
            if (boss) {
                r = 128;
                g = 0;
                b = 128;
            }
            if (entity instanceof Monster) {
                r = 255;
                g = 0;
                b = 0;
            }
            return 0xFF000000 | r << 16 | g << 8 | b;
        }
        float health = Mth.m_14036_((float)entity.m_21223_(), (float)0.0f, (float)entity.m_21233_());
        float hue = Math.max(0.0f, health / entity.m_21233_() / 3.0f - 0.07f);
        return Mth.m_14169_((float)hue, (float)1.0f, (float)1.0f);
    }

    private static boolean isBoss(Entity entity) {
        return !entity.m_6072_();
    }

    private static boolean shouldShowPlate(Entity entity, Entity cameraEntity) {
        if (!NeatConfig.instance.renderInF1() && !Minecraft.m_91404_() || !NeatConfig.draw) {
            return false;
        }
        if (!(entity instanceof LivingEntity)) {
            return false;
        }
        LivingEntity living = (LivingEntity)entity;
        ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)living.m_6095_());
        if (NeatConfig.instance.blacklist().contains(id.toString())) {
            return false;
        }
        float distance = living.m_20270_(cameraEntity);
        if (distance > (float)NeatConfig.instance.maxDistance() || !living.m_142582_(cameraEntity) || living.m_20145_()) {
            return false;
        }
        if (!NeatConfig.instance.showOnBosses() && HealthBarRenderer.isBoss((Entity)living)) {
            return false;
        }
        if (!NeatConfig.instance.showOnPlayers() && living instanceof Player) {
            return false;
        }
        if (!NeatConfig.instance.showFullHealth() && living.m_21223_() >= living.m_21233_()) {
            return false;
        }
        return !NeatConfig.instance.showOnlyFocused() || HealthBarRenderer.getEntityLookedAt(cameraEntity) == entity;
    }

    public static void hookRender(Entity entity, PoseStack poseStack, MultiBufferSource buffers, Quaternionf cameraOrientation) {
        int armor;
        LivingEntity living;
        Minecraft mc;
        block16: {
            block15: {
                mc = Minecraft.m_91087_();
                if (!(entity instanceof LivingEntity)) break block15;
                living = (LivingEntity)entity;
                if (entity.m_20197_().isEmpty()) break block16;
            }
            return;
        }
        if (!HealthBarRenderer.shouldShowPlate(entity, mc.f_91063_.m_109153_().m_90592_())) {
            return;
        }
        int light = 0xF000F0;
        float globalScale = 0.0267f;
        float textScale = 0.5f;
        int barHeight = NeatConfig.instance.barHeight();
        boolean boss = HealthBarRenderer.isBoss(entity);
        String name = entity.m_8077_() ? ChatFormatting.ITALIC + entity.m_7770_().getString() : entity.m_5446_().getString();
        float nameLen = (float)mc.f_91062_.m_92895_(name) * 0.5f;
        float halfSize = Math.max((float)NeatConfig.instance.plateSize(), nameLen / 2.0f + 10.0f);
        poseStack.m_85836_();
        poseStack.m_85837_(0.0, (double)entity.m_20206_() + NeatConfig.instance.heightAbove(), 0.0);
        poseStack.m_252781_(cameraOrientation);
        poseStack.m_85836_();
        poseStack.m_85841_(-0.0267f, -0.0267f, 0.0267f);
        if (NeatConfig.instance.drawBackground()) {
            float padding = NeatConfig.instance.backgroundPadding();
            int bgHeight = NeatConfig.instance.backgroundHeight();
            VertexConsumer builder = buffers.m_6299_(NeatRenderType.BAR_TEXTURE_TYPE);
            builder.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize - padding, (float)(-bgHeight), 0.01f).m_6122_(0, 0, 0, 64).m_7421_(0.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize - padding, (float)barHeight + padding, 0.01f).m_6122_(0, 0, 0, 64).m_7421_(0.0f, 0.5f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), halfSize + padding, (float)barHeight + padding, 0.01f).m_6122_(0, 0, 0, 64).m_7421_(1.0f, 0.5f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), halfSize + padding, (float)(-bgHeight), 0.01f).m_6122_(0, 0, 0, 64).m_7421_(1.0f, 0.0f).m_85969_(0xF000F0).m_5752_();
        }
        int argb = HealthBarRenderer.getColor(living, NeatConfig.instance.colorByType(), boss);
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        float maxHealth = Math.max(living.m_21223_(), living.m_21233_());
        float healthHalfSize = halfSize * (living.m_21223_() / maxHealth);
        VertexConsumer builder = buffers.m_6299_(NeatRenderType.BAR_TEXTURE_TYPE);
        builder.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize, 0.0f, 0.001f).m_6122_(r, g, b, 127).m_7421_(0.0f, 0.75f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize, (float)barHeight, 0.001f).m_6122_(r, g, b, 127).m_7421_(0.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize + 2.0f * healthHalfSize, (float)barHeight, 0.001f).m_6122_(r, g, b, 127).m_7421_(1.0f, 1.0f).m_85969_(0xF000F0).m_5752_();
        builder.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize + 2.0f * healthHalfSize, 0.0f, 0.001f).m_6122_(r, g, b, 127).m_7421_(1.0f, 0.75f).m_85969_(0xF000F0).m_5752_();
        if (healthHalfSize < halfSize) {
            builder.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize + 2.0f * healthHalfSize, 0.0f, 0.001f).m_6122_(0, 0, 0, 127).m_7421_(0.0f, 0.5f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), -halfSize + 2.0f * healthHalfSize, (float)barHeight, 0.001f).m_6122_(0, 0, 0, 127).m_7421_(0.0f, 0.75f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), halfSize, (float)barHeight, 0.001f).m_6122_(0, 0, 0, 127).m_7421_(1.0f, 0.75f).m_85969_(0xF000F0).m_5752_();
            builder.m_252986_(poseStack.m_85850_().m_252922_(), halfSize, 0.0f, 0.001f).m_6122_(0, 0, 0, 127).m_7421_(1.0f, 0.5f).m_85969_(0xF000F0).m_5752_();
        }
        int white = 0xFFFFFF;
        boolean black = false;
        poseStack.m_85836_();
        poseStack.m_252880_(-halfSize, -4.5f, 0.0f);
        poseStack.m_85841_(0.5f, 0.5f, 0.5f);
        mc.f_91062_.m_252905_(name, 0.0f, 0.0f, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), buffers, false, 0, 0xF000F0);
        poseStack.m_85849_();
        float healthValueTextScale = 0.375f;
        poseStack.m_85836_();
        poseStack.m_252880_(-halfSize, -4.5f, 0.0f);
        poseStack.m_85841_(0.375f, 0.375f, 0.375f);
        int h = NeatConfig.instance.hpTextHeight();
        if (NeatConfig.instance.showCurrentHP()) {
            String hpStr = HEALTH_FORMAT.format(living.m_21223_());
            mc.f_91062_.m_252905_(hpStr, 2.0f, (float)h, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), buffers, false, 0, 0xF000F0);
        }
        if (NeatConfig.instance.showMaxHP()) {
            String maxHpStr = ChatFormatting.BOLD + HEALTH_FORMAT.format(living.m_21233_());
            mc.f_91062_.m_252905_(maxHpStr, (float)((int)(halfSize / 0.375f * 2.0f) - mc.f_91062_.m_92895_(maxHpStr) - 2), (float)h, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), buffers, false, 0, 0xF000F0);
        }
        if (NeatConfig.instance.showPercentage()) {
            String percStr = (int)(100.0f * living.m_21223_() / living.m_21233_()) + "%";
            mc.f_91062_.m_252905_(percStr, (float)((int)(halfSize / 0.375f)) - (float)mc.f_91062_.m_92895_(percStr) / 2.0f, (float)h, 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), buffers, false, 0, 0xF000F0);
        }
        if (NeatConfig.instance.enableDebugInfo() && mc.f_91066_.f_92063_) {
            ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)entity.m_6095_());
            mc.f_91062_.m_252905_("ID: \"" + id + "\"", 0.0f, (float)(h + 16), 0xFFFFFF, false, poseStack.m_85850_().m_252922_(), buffers, false, 0, 0xF000F0);
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
        float zBump = -0.1f;
        poseStack.m_85836_();
        float iconOffset = 2.85f;
        float zShift = 0.0f;
        if (NeatConfig.instance.showAttributes()) {
            ItemStack icon = HealthBarRenderer.getIcon(living, boss);
            HealthBarRenderer.renderIcon(icon, poseStack, buffers, 0.0267f, halfSize, iconOffset, zShift);
            iconOffset += 5.0f;
            zShift += -0.1f;
        }
        if ((armor = living.m_21230_()) > 0 && NeatConfig.instance.showArmor()) {
            int ironArmor = armor % 5;
            int diamondArmor = armor / 5;
            if (!NeatConfig.instance.groupArmor()) {
                ironArmor = armor;
                diamondArmor = 0;
            }
            ItemStack iron = new ItemStack((ItemLike)Items.f_42469_);
            for (int i = 0; i < ironArmor; ++i) {
                HealthBarRenderer.renderIcon(iron, poseStack, buffers, 0.0267f, halfSize, iconOffset, zShift);
                iconOffset += 1.0f;
                zShift += -0.1f;
            }
            ItemStack diamond = new ItemStack((ItemLike)Items.f_42473_);
            for (int i = 0; i < diamondArmor; ++i) {
                HealthBarRenderer.renderIcon(diamond, poseStack, buffers, 0.0267f, halfSize, iconOffset, zShift);
                iconOffset += 1.0f;
                zShift += -0.1f;
            }
        }
        poseStack.m_85849_();
        poseStack.m_85849_();
    }

    private static void renderIcon(ItemStack icon, PoseStack poseStack, MultiBufferSource buffers, float globalScale, float halfSize, float leftShift, float zShift) {
        if (!icon.m_41619_()) {
            float iconScale = 0.12f;
            poseStack.m_85836_();
            float dx = (halfSize - leftShift) * globalScale;
            float dy = 3.0f * globalScale;
            float dz = zShift * globalScale;
            poseStack.m_252880_(-dx, dy, dz);
            poseStack.m_85841_(0.12f, 0.12f, 0.12f);
            poseStack.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            Minecraft.m_91087_().m_91291_().m_174269_(icon, ItemTransforms.TransformType.NONE, 0xF000F0, OverlayTexture.f_118083_, poseStack, buffers, 0);
            poseStack.m_85849_();
        }
    }
}

