/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.item.BoatEntity;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;

public class BoatAnimation
extends BasicAnimation {
    private final BodyPart[] bothHands = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM};

    @Override
    public boolean isEnabled() {
        return NEABaseMod.config.enableRowBoatAnimation;
    }

    @Override
    public boolean isValid(AbstractClientPlayerEntity entity, PlayerData data) {
        return entity.func_184218_aH() && entity.func_184187_bx() instanceof BoatEntity;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayerEntity entity, PlayerData data) {
        return this.bothHands;
    }

    @Override
    public int getPriority(AbstractClientPlayerEntity entity, PlayerData data) {
        return 1500;
    }

    @Override
    public void apply(AbstractClientPlayerEntity entity, PlayerData data, PlayerModel<AbstractClientPlayerEntity> model, BodyPart part, float delta, float tickCounter) {
        if (part == BodyPart.BODY) {
            return;
        }
        if (part == BodyPart.LEFT_ARM && AnimationUtil.isSwingingArm(entity, part)) {
            return;
        }
        if (part == BodyPart.RIGHT_ARM && AnimationUtil.isSwingingArm(entity, part)) {
            return;
        }
        HandSide arm = part == BodyPart.LEFT_ARM ? HandSide.LEFT : HandSide.RIGHT;
        BoatEntity boat = (BoatEntity)entity.func_184187_bx();
        int id = boat.func_184188_bt().indexOf(entity);
        if (id == 0) {
            float paddle = boat.func_184448_a(arm == HandSide.LEFT ? 0 : 1, delta);
            AnimationUtil.applyArmTransforms(model, arm, -1.1f - MathHelper.func_76126_a((float)paddle) * 0.3f, 0.2f, 0.3f);
        }
    }
}

