/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.util.NMSHelper;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.item.UseAction;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;

public class EatDrinkAnimation
extends BasicAnimation {
    private BodyPart[] target;
    private final BodyPart[] left = new BodyPart[]{BodyPart.LEFT_ARM};
    private final BodyPart[] right = new BodyPart[]{BodyPart.RIGHT_ARM};
    private final BodyPart[] leftFixed = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.BODY};
    private final BodyPart[] rightFixed = new BodyPart[]{BodyPart.RIGHT_ARM, BodyPart.BODY};

    @Override
    public boolean isEnabled() {
        return NEABaseMod.config.enableEatDrinkAnimation;
    }

    @Override
    public boolean isValid(AbstractClientPlayerEntity entity, PlayerData data) {
        UseAction action;
        if (entity.func_184605_cv() > 0 && ((action = entity.func_184607_cu().func_77975_n()) == UseAction.EAT || action == UseAction.DRINK)) {
            this.target = entity.func_184600_cs() == Hand.MAIN_HAND ? (entity.func_184591_cq() == HandSide.RIGHT ? (NEABaseMod.config.enableRotationLocking ? this.rightFixed : this.right) : (NEABaseMod.config.enableRotationLocking ? this.leftFixed : this.left)) : (entity.func_184591_cq() == HandSide.RIGHT ? (NEABaseMod.config.enableRotationLocking ? this.leftFixed : this.left) : (NEABaseMod.config.enableRotationLocking ? this.rightFixed : this.right));
            return true;
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayerEntity entity, PlayerData data) {
        return this.target;
    }

    @Override
    public int getPriority(AbstractClientPlayerEntity entity, PlayerData data) {
        return 2500;
    }

    @Override
    public void apply(AbstractClientPlayerEntity entity, PlayerData data, PlayerModel<AbstractClientPlayerEntity> model, BodyPart part, float delta, float tickCounter) {
        if (part == BodyPart.BODY) {
            data.disableBodyRotation(true);
            entity.func_181013_g(entity.func_70079_am());
            entity.field_70760_ar = entity.field_70758_at;
            return;
        }
        HandSide arm = part == BodyPart.LEFT_ARM ? HandSide.LEFT : HandSide.RIGHT;
        float g = (float)entity.func_184605_cv() - delta + 1.0f;
        AnimationUtil.applyArmTransforms(model, arm, -MathHelper.func_219799_g((float)(-1.0f * (NMSHelper.getXRot((Entity)entity) - 90.0f) / 180.0f), (float)1.0f, (float)2.0f) + MathHelper.func_76135_e((float)(MathHelper.func_76134_b((float)(g / 4.0f * (float)Math.PI)) * 0.2f)), -0.3f, 0.3f);
    }
}

