/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class HugAnimation
extends BasicAnimation {
    private final BodyPart[] arms = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM};

    @Override
    public boolean isEnabled() {
        return NEABaseMod.config.huggingAnimation;
    }

    @Override
    public boolean isValid(AbstractClientPlayerEntity entity, PlayerData data) {
        AxisAlignedBB aABB;
        if (!entity.func_213453_ef()) {
            return false;
        }
        double d = 1.0;
        Vector3d vec3 = entity.func_174824_e(0.0f);
        Vector3d vec32 = entity.func_70676_i(1.0f);
        Vector3d vec33 = vec3.func_72441_c(vec32.field_72450_a * d, vec32.field_72448_b * d, vec32.field_72449_c * d);
        EntityRayTraceResult entHit = ProjectileHelper.func_221273_a((Entity)entity, (Vector3d)vec3, (Vector3d)vec33, (AxisAlignedBB)(aABB = entity.func_174813_aQ().func_216361_a(vec32.func_186678_a(d)).func_72314_b(1.0, 1.0, 1.0)), en -> !en.func_175149_v(), (double)d);
        if (entHit != null && entHit.func_216348_a().func_200600_R() == EntityType.field_200729_aH) {
            AbstractClientPlayerEntity otherPlayer = (AbstractClientPlayerEntity)entHit.func_216348_a();
            double dif = otherPlayer.func_226278_cu_() - entity.func_226278_cu_();
            if (otherPlayer.func_213453_ef() && Math.abs(dif) < 0.3) {
                return true;
            }
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayerEntity entity, PlayerData data) {
        return this.arms;
    }

    @Override
    public int getPriority(AbstractClientPlayerEntity entity, PlayerData data) {
        return 2100;
    }

    @Override
    public void apply(AbstractClientPlayerEntity entity, PlayerData data, PlayerModel<AbstractClientPlayerEntity> model, BodyPart part, float delta, float tickCounter) {
        if (part == BodyPart.LEFT_ARM) {
            AnimationUtil.applyArmTransforms(model, HandSide.LEFT, -1.0f, -0.2f, 0.3f);
        }
        if (part == BodyPart.RIGHT_ARM) {
            AnimationUtil.applyArmTransforms(model, HandSide.RIGHT, -1.5f, -0.2f, 0.3f);
        }
    }
}

