/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.item.ItemStack;
import net.minecraft.util.HandSide;
import net.minecraft.util.math.MathHelper;

public class ItemSwapAnimation
extends BasicAnimation {
    private final BodyPart[] parts = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM};

    @Override
    public boolean isEnabled() {
        return NEABaseMod.config.itemSwapAnimation;
    }

    @Override
    public boolean isValid(AbstractClientPlayerEntity entity, PlayerData data) {
        if (data.getLastAnimationSwapTick() != entity.field_70173_aa) {
            data.setLastAnimationSwapTick(entity.field_70173_aa);
            if (data.getLastHeldItems()[0] == null) {
                data.getLastHeldItems()[0] = entity.func_184614_ca();
                data.getLastHeldItems()[1] = entity.func_184592_cb();
            }
            ItemStack mainHand = entity.func_184614_ca();
            ItemStack offHand = entity.func_184592_cb();
            if (!(mainHand.func_190926_b() && offHand.func_190926_b() || data.getLastHeldItems()[0].func_77973_b() == data.getLastHeldItems()[1].func_77973_b() || data.getLastHeldItems()[0].func_77973_b() != offHand.func_77973_b() || data.getLastHeldItems()[1].func_77973_b() != mainHand.func_77973_b())) {
                data.setItemSwapAnimationTimer(10);
            }
            data.getLastHeldItems()[0] = entity.func_184614_ca();
            data.getLastHeldItems()[1] = entity.func_184592_cb();
            if (data.getItemSwapAnimationTimer() > 0) {
                data.setItemSwapAnimationTimer(data.getItemSwapAnimationTimer() - 1);
            }
        }
        return data.getItemSwapAnimationTimer() > 0;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayerEntity entity, PlayerData data) {
        return this.parts;
    }

    @Override
    public int getPriority(AbstractClientPlayerEntity entity, PlayerData data) {
        return 3500;
    }

    @Override
    public void apply(AbstractClientPlayerEntity entity, PlayerData data, PlayerModel<AbstractClientPlayerEntity> model, BodyPart part, float delta, float tickCounter) {
        int animationTick = data.getItemSwapAnimationTimer();
        float position = (float)animationTick / 10.0f * -1.0f;
        position = MathHelper.func_219799_g((float)delta, (float)((float)(animationTick + 1) / 10.0f * -1.0f), (float)position);
        if (part == BodyPart.LEFT_ARM) {
            AnimationUtil.applyArmTransforms(model, HandSide.LEFT, -0.5f, 0.2f, position);
        }
        if (part == BodyPart.RIGHT_ARM) {
            AnimationUtil.applyArmTransforms(model, HandSide.RIGHT, -0.5f, 0.2f, position);
        }
    }
}

