/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.util.NMSHelper;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import dev.tr7zw.notenoughanimations.versionless.animations.HoldUpModes;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class LookAtItemAnimation
extends BasicAnimation {
    private Set<Item> holdingItems = new HashSet<Item>();
    private final BodyPart[] bothHands = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM};
    private final BodyPart[] left = new BodyPart[]{BodyPart.LEFT_ARM};
    private final BodyPart[] right = new BodyPart[]{BodyPart.RIGHT_ARM};
    private BodyPart[] target = this.bothHands;

    @Override
    public boolean isEnabled() {
        this.bind();
        return NEABaseMod.config.holdUpItemsMode != HoldUpModes.NONE && !this.holdingItems.isEmpty();
    }

    private void bind() {
        this.holdingItems.clear();
        Item invalid = NMSHelper.getItem(new ResourceLocation("minecraft", "air"));
        for (String itemId : NEABaseMod.config.holdingItems) {
            try {
                Item item = NMSHelper.getItem(new ResourceLocation(itemId.split(":")[0], itemId.split(":")[1]));
                if (invalid == item) continue;
                this.holdingItems.add(item);
            }
            catch (Exception ex) {
                String string = itemId;
                NEABaseMod.LOGGER.info("Unknown item to add to the holding list: " + string);
            }
        }
    }

    @Override
    public boolean isValid(AbstractClientPlayerEntity entity, PlayerData data) {
        boolean leftArm;
        boolean allItems = NEABaseMod.config.holdUpItemsMode == HoldUpModes.ALL;
        ItemStack itemInRightHand = entity.func_184586_b(entity.func_184591_cq() == HandSide.LEFT ? Hand.OFF_HAND : Hand.MAIN_HAND);
        ItemStack itemInLeftHand = entity.func_184586_b(entity.func_184591_cq() == HandSide.RIGHT ? Hand.OFF_HAND : Hand.MAIN_HAND);
        boolean rightArm = this.holdingItems.contains(itemInRightHand.func_77973_b()) || allItems && !itemInRightHand.func_190926_b() && (!entity.field_82175_bq || entity.func_184591_cq() != HandSide.RIGHT);
        boolean bl = leftArm = this.holdingItems.contains(itemInLeftHand.func_77973_b()) || allItems && !itemInLeftHand.func_190926_b() && (!entity.field_82175_bq || entity.func_184591_cq() != HandSide.LEFT);
        if (rightArm && leftArm && !entity.field_82175_bq) {
            this.target = this.bothHands;
            return true;
        }
        if (rightArm && (!entity.field_82175_bq || entity.field_184622_au != (entity.func_184591_cq() == HandSide.LEFT ? Hand.OFF_HAND : Hand.MAIN_HAND))) {
            this.target = this.right;
            return true;
        }
        if (leftArm && (!entity.field_82175_bq || entity.field_184622_au != (entity.func_184591_cq() == HandSide.RIGHT ? Hand.OFF_HAND : Hand.MAIN_HAND))) {
            this.target = this.left;
            return true;
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayerEntity entity, PlayerData data) {
        return this.target;
    }

    @Override
    public int getPriority(AbstractClientPlayerEntity entity, PlayerData data) {
        return 300;
    }

    @Override
    public void apply(AbstractClientPlayerEntity entity, PlayerData data, PlayerModel<AbstractClientPlayerEntity> model, BodyPart part, float delta, float tickCounter) {
        HandSide arm = part == BodyPart.LEFT_ARM ? HandSide.LEFT : HandSide.RIGHT;
        AnimationUtil.applyArmTransforms(model, arm, -NEABaseMod.config.holdUpItemOffset - MathHelper.func_219799_g((float)(-1.0f * (NMSHelper.getXRot((Entity)entity) - 90.0f) / 180.0f), (float)1.0f, (float)1.5f), -0.2f, 0.3f);
    }
}

