/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.util.NMSHelper;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;

public class MapHoldingAnimation
extends BasicAnimation {
    private Set<Item> compatibleMaps = new HashSet<Item>();
    private final BodyPart[] bothHands = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM};
    private final BodyPart[] left = new BodyPart[]{BodyPart.LEFT_ARM};
    private final BodyPart[] right = new BodyPart[]{BodyPart.RIGHT_ARM};
    private BodyPart[] target = this.bothHands;

    @Override
    public boolean isEnabled() {
        this.bind();
        return NEABaseMod.config.enableInWorldMapRendering || !this.compatibleMaps.isEmpty();
    }

    private void bind() {
        this.compatibleMaps.clear();
        Item invalid = NMSHelper.getItem(new ResourceLocation("minecraft", "air"));
        this.compatibleMaps.add(NMSHelper.getItem(new ResourceLocation("minecraft", "filled_map")));
        Item antiqueAtlas = NMSHelper.getItem(new ResourceLocation("antiqueatlas", "antique_atlas"));
        if (invalid != antiqueAtlas) {
            this.compatibleMaps.add(antiqueAtlas);
            NEABaseMod.LOGGER.info("Added AntiqueAtlas support to Not Enough Animations!");
        }
    }

    @Override
    public boolean isValid(AbstractClientPlayerEntity entity, PlayerData data) {
        ItemStack itemInMainHand = entity.func_184586_b(Hand.MAIN_HAND);
        ItemStack itemInOffHand = entity.func_184586_b(Hand.OFF_HAND);
        if (this.compatibleMaps.contains(itemInMainHand.func_77973_b()) && itemInOffHand.func_190926_b()) {
            if (itemInMainHand.func_77942_o() && itemInMainHand.func_77978_p().func_74764_b("CustomModelData")) {
                return false;
            }
            this.target = this.bothHands;
            return true;
        }
        if (this.compatibleMaps.contains(itemInMainHand.func_77973_b()) && !itemInOffHand.func_190926_b()) {
            if (itemInMainHand.func_77942_o() && itemInMainHand.func_77978_p().func_74764_b("CustomModelData")) {
                return false;
            }
            this.target = entity.func_184591_cq() == HandSide.RIGHT ? this.right : this.left;
            return true;
        }
        if (this.compatibleMaps.contains(itemInOffHand.func_77973_b()) && !itemInOffHand.func_190926_b()) {
            if (itemInMainHand.func_77942_o() && itemInMainHand.func_77978_p().func_74764_b("CustomModelData")) {
                return false;
            }
            this.target = entity.func_184591_cq() == HandSide.RIGHT ? this.left : this.right;
            return true;
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayerEntity entity, PlayerData data) {
        return this.target;
    }

    @Override
    public int getPriority(AbstractClientPlayerEntity entity, PlayerData data) {
        return 300;
    }

    @Override
    public void apply(AbstractClientPlayerEntity entity, PlayerData data, PlayerModel<AbstractClientPlayerEntity> model, BodyPart part, float delta, float tickCounter) {
        HandSide arm;
        HandSide handSide = arm = part == BodyPart.LEFT_ARM ? HandSide.LEFT : HandSide.RIGHT;
        if (this.target == this.bothHands) {
            AnimationUtil.applyArmTransforms(model, arm, -MathHelper.func_219799_g((float)(-1.0f * (NMSHelper.getXRot((Entity)entity) - 90.0f) / 180.0f), (float)0.5f, (float)1.5f), -0.4f, 0.3f);
            return;
        }
        AnimationUtil.applyArmTransforms(model, arm, -MathHelper.func_219799_g((float)(-1.0f * (NMSHelper.getXRot((Entity)entity) - 90.0f) / 180.0f), (float)0.5f, (float)1.5f), 0.0f, 0.3f);
    }
}

