/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.vanilla;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import java.util.EnumSet;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;

public class VanillaSingleHandedAnimation
extends BasicAnimation {
    private BipedModel.ArmPose rightArmPose;
    private BipedModel.ArmPose leftArmPose;
    private final EnumSet<BipedModel.ArmPose> singleHandedAnimatios = EnumSet.of(BipedModel.ArmPose.THROW_SPEAR);
    private final BodyPart[] left = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.BODY};
    private final BodyPart[] right = new BodyPart[]{BodyPart.RIGHT_ARM, BodyPart.BODY};

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public boolean isValid(AbstractClientPlayerEntity entity, PlayerData data) {
        this.rightArmPose = AnimationUtil.getArmPose(entity, entity.func_184591_cq() == HandSide.LEFT ? Hand.OFF_HAND : Hand.MAIN_HAND);
        this.leftArmPose = AnimationUtil.getArmPose(entity, entity.func_184591_cq() == HandSide.RIGHT ? Hand.OFF_HAND : Hand.MAIN_HAND);
        return this.singleHandedAnimatios.contains(this.leftArmPose) || this.singleHandedAnimatios.contains(this.rightArmPose);
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayerEntity entity, PlayerData data) {
        if (this.singleHandedAnimatios.contains(this.leftArmPose)) {
            return this.left;
        }
        if (this.singleHandedAnimatios.contains(this.rightArmPose)) {
            return this.right;
        }
        return new BodyPart[0];
    }

    @Override
    public int getPriority(AbstractClientPlayerEntity entity, PlayerData data) {
        return 3100;
    }

    @Override
    public void apply(AbstractClientPlayerEntity entity, PlayerData data, PlayerModel<AbstractClientPlayerEntity> model, BodyPart part, float delta, float tickCounter) {
    }
}

