/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.config;

import com.mojang.blaze3d.matrix.MatrixStack;
import dev.tr7zw.notenoughanimations.util.ComponentProvider;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.DialogTexts;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IBidiTooltip;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.OptionSlider;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.list.OptionsRowList;
import net.minecraft.client.settings.BooleanOption;
import net.minecraft.client.settings.IteratableOption;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TranslationTextComponent;

public abstract class CustomConfigScreen
extends Screen {
    protected final Screen lastScreen;
    OptionsRowList list;

    public CustomConfigScreen(Screen lastScreen, String title) {
        super((ITextComponent)new TranslationTextComponent(title));
        this.lastScreen = lastScreen;
    }

    public void func_231164_f_() {
        this.save();
    }

    public void func_231175_as__() {
        this.field_230706_i_.func_147108_a(this.lastScreen);
    }

    public OptionsRowList getOptions() {
        return this.list;
    }

    protected void func_231160_c_() {
        this.list = new OptionsRowList(this.field_230706_i_, this.field_230708_k_, this.field_230709_l_, 32, this.field_230709_l_ - 32, 25);
        this.func_230481_d_((IGuiEventListener)this.list);
        this.createFooter();
        this.initialize();
    }

    public abstract void initialize();

    public abstract void save();

    public abstract void reset();

    protected void createFooter() {
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 - 100, this.field_230709_l_ - 27, 200, 20, DialogTexts.field_240632_c_, new Button.IPressable(){

            public void onPress(Button button) {
                CustomConfigScreen.this.func_231175_as__();
            }
        }));
        this.func_230480_a_((Widget)new Button(this.field_230708_k_ / 2 + 110, this.field_230709_l_ - 27, 60, 20, (ITextComponent)new TranslationTextComponent("controls.reset"), new Button.IPressable(){

            public void onPress(Button button) {
                CustomConfigScreen.this.reset();
                CustomConfigScreen.this.func_231152_a_(CustomConfigScreen.this.field_230706_i_, CustomConfigScreen.this.field_230708_k_, CustomConfigScreen.this.field_230709_l_);
            }
        }));
        this.func_230480_a_((Widget)new PlainTextButton(5, 5, 400, 20, (ITextComponent)ComponentProvider.literal("Enjoying the mod? Consider supporting the developer!"), new Button.IPressable(){

            public void onPress(Button button) {
                Util.func_110647_a().func_195640_a("https://tr7zw.dev/donate/");
            }
        }, this.field_230706_i_.field_71466_p));
    }

    public void func_230430_a_(MatrixStack poseStack, int i, int j, float f) {
        this.func_230446_a_(poseStack);
        this.list.func_230430_a_(poseStack, i, j, f);
        CustomConfigScreen.func_238472_a_((MatrixStack)poseStack, (FontRenderer)this.field_230712_o_, (ITextComponent)this.field_230704_d_, (int)(this.field_230708_k_ / 2), (int)20, (int)0xFFFFFF);
        List<IReorderingProcessor> tooltip = CustomConfigScreen.tooltipAt(this.list, i, j);
        if (tooltip != null) {
            this.func_238654_b_(poseStack, tooltip, i, j);
        }
        super.func_230430_a_(poseStack, i, j, f);
    }

    void updateText(SliderPercentageOption option) {
        Widget widget = this.getOptions().func_243271_b((AbstractOption)option);
        if (widget instanceof OptionSlider) {
            ((OptionSlider)widget).func_238482_a_(option.func_238334_c_(Minecraft.func_71410_x().field_71474_y));
        }
    }

    public BooleanOption getBooleanOption(String translationKey, Supplier<Boolean> current, Consumer<Boolean> update) {
        BooleanOption option = new BooleanOption(translationKey, null, options -> (Boolean)current.get(), (options, b) -> update.accept((Boolean)b));
        option.func_241567_a_(this.createStaticTooltip(translationKey));
        return option;
    }

    public BooleanOption getOnOffOption(String translationKey, Supplier<Boolean> current, Consumer<Boolean> update) {
        return this.getBooleanOption(translationKey, current, update);
    }

    public SliderPercentageOption getDoubleOption(String translationKey, float min, float max, float steps, Supplier<Double> current, Consumer<Double> update) {
        TranslationTextComponent comp = new TranslationTextComponent(translationKey);
        SliderPercentageOption option = new SliderPercentageOption(translationKey, (double)min, (double)max, steps, options -> (Double)current.get(), (options, val) -> update.accept((Double)val), (options, opt) -> {
            double d = CustomConfigScreen.round(opt.func_216729_a(options), 3);
            return comp.func_230529_a_((ITextComponent)new StringTextComponent(": " + d));
        });
        option.func_241567_a_(this.createStaticTooltip(translationKey));
        return option;
    }

    public SliderPercentageOption getIntOption(String translationKey, float min, float max, Supplier<Integer> current, Consumer<Integer> update) {
        TranslationTextComponent comp = new TranslationTextComponent(translationKey);
        AtomicReference<SliderPercentageOption> option = new AtomicReference<SliderPercentageOption>();
        option.set(new SliderPercentageOption(translationKey, (double)min, (double)max, 1.0f, options -> (double)((Integer)current.get()), (options, val) -> {
            update.accept(val.intValue());
            this.updateText((SliderPercentageOption)option.get());
        }, (options, opt) -> {
            Object t = current.get();
            return comp.func_230532_e_().func_240702_b_(": " + t);
        }));
        ((SliderPercentageOption)option.get()).func_241567_a_(this.createStaticTooltip(translationKey));
        return (SliderPercentageOption)option.get();
    }

    public <T extends Enum> IteratableOption getEnumOption(String translationKey, Class<T> targetEnum, Supplier<T> current, Consumer<T> update) {
        IteratableOption option = new IteratableOption(translationKey, (options, integer) -> update.accept(((Enum[])targetEnum.getEnumConstants())[(((Enum)current.get()).ordinal() + integer) % ((Enum[])targetEnum.getEnumConstants()).length]), (options, cycleOption) -> {
            cycleOption.func_241567_a_(this.createStaticTooltip(translationKey));
            String string = ((Enum)current.get()).name();
            String string2 = translationKey;
            return new TranslationTextComponent(translationKey).func_240702_b_(": ").func_230529_a_((ITextComponent)new TranslationTextComponent(string2 + "." + string));
        });
        return option;
    }

    public List<IReorderingProcessor> createStaticTooltip(String translationKey) {
        TranslationTextComponent comp;
        String string = translationKey;
        String key = string + ".tooltip";
        if (key.equals((comp = new TranslationTextComponent(key)).getString())) {
            return null;
        }
        return this.field_230706_i_.field_71466_p.func_238425_b_((ITextProperties)comp, 170);
    }

    public static List<IReorderingProcessor> tooltipAt(OptionsRowList arg, int i, int j) {
        if (!arg.func_231047_b_((double)i, (double)j)) {
            return null;
        }
        Optional optional = arg.func_238518_c_((double)i, (double)j);
        if (optional.isPresent() && optional.get() instanceof IBidiTooltip) {
            Optional optional2 = ((IBidiTooltip)optional.get()).func_241867_d();
            return optional2.orElse(null);
        }
        return null;
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public class PlainTextButton
    extends Button {
        final FontRenderer font;
        final ITextComponent message;
        final ITextComponent underlinedMessage;

        public PlainTextButton(int x, int y, int width, int height, ITextComponent message, Button.IPressable onPress, FontRenderer font) {
            super(x, y, width, height, message, onPress);
            this.font = font;
            this.message = message;
            this.underlinedMessage = TextComponentUtils.func_240648_a_((IFormattableTextComponent)message.func_230532_e_(), (Style)Style.field_240709_b_.func_244282_c(Boolean.valueOf(true)));
        }

        public void func_230431_b_(MatrixStack poseStack, int mouseX, int mouseY, float partialTick) {
            ITextComponent component = this.func_230449_g_() ? this.underlinedMessage : this.message;
            PlainTextButton.func_238475_b_((MatrixStack)poseStack, (FontRenderer)this.font, (ITextComponent)component, (int)this.field_230690_l_, (int)this.field_230691_m_, (int)(0xFFFFFF | MathHelper.func_76123_f((float)(this.field_230695_q_ * 255.0f)) << 24));
        }
    }
}

