/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.config;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.tr7zw.notenoughanimations.util.ComponentProvider;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.CycleOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Option;
import net.minecraft.client.ProgressOption;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.CycleButton;
import net.minecraft.client.gui.components.OptionsList;
import net.minecraft.client.gui.components.SliderButton;
import net.minecraft.client.gui.components.TooltipAccessor;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public abstract class CustomConfigScreen
extends Screen {
    protected final Screen lastScreen;
    private OptionsList list;

    public CustomConfigScreen(Screen lastScreen, String title) {
        super((Component)new TranslatableComponent(title));
        this.lastScreen = lastScreen;
    }

    public void m_7861_() {
        this.save();
    }

    public void m_7379_() {
        this.f_96541_.m_91152_(this.lastScreen);
    }

    public OptionsList getOptions() {
        return this.list;
    }

    protected void m_7856_() {
        this.list = new OptionsList(this.f_96541_, this.f_96543_, this.f_96544_, 32, this.f_96544_ - 32, 25);
        this.m_7787_((GuiEventListener)this.list);
        this.createFooter();
        this.initialize();
    }

    public abstract void initialize();

    public abstract void reset();

    public abstract void save();

    protected void createFooter() {
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 - 100, this.f_96544_ - 27, 200, 20, CommonComponents.f_130655_, new Button.OnPress(){

            public void m_93750_(Button button) {
                CustomConfigScreen.this.m_7379_();
            }
        }));
        this.m_142416_((GuiEventListener)new Button(this.f_96543_ / 2 + 110, this.f_96544_ - 27, 60, 20, (Component)new TranslatableComponent("controls.reset"), new Button.OnPress(){

            public void m_93750_(Button button) {
                CustomConfigScreen.this.reset();
                CustomConfigScreen.this.m_6574_(CustomConfigScreen.this.f_96541_, CustomConfigScreen.this.f_96543_, CustomConfigScreen.this.f_96544_);
            }
        }));
        this.m_142416_((GuiEventListener)new PlainTextButton(5, 5, 400, 20, (Component)ComponentProvider.literal("Enjoying the mod? Consider supporting the developer!"), new Button.OnPress(){

            public void m_93750_(Button button) {
                Util.m_137581_().m_137646_("https://tr7zw.dev/donate/");
            }
        }, this.f_96541_.f_91062_));
    }

    public void m_6305_(PoseStack poseStack, int i, int j, float f) {
        this.m_7333_(poseStack);
        this.list.m_6305_(poseStack, i, j, f);
        CustomConfigScreen.m_93215_((PoseStack)poseStack, (Font)this.f_96547_, (Component)this.f_96539_, (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        super.m_6305_(poseStack, i, j, f);
        List<FormattedCharSequence> list = CustomConfigScreen.tooltipAt(this.list, i, j);
        this.m_96617_(poseStack, list, i, j);
    }

    private void updateText(ProgressOption option) {
        AbstractWidget widget = this.getOptions().m_94478_((Option)option);
        if (widget instanceof SliderButton) {
            ((SliderButton)widget).m_93666_(option.m_92233_(Minecraft.m_91087_().f_91066_));
        } else {
            System.out.println(widget.getClass().getName());
        }
    }

    private List<FormattedCharSequence> getTooltip(String translationKey) {
        TranslatableComponent comp;
        String key = translationKey + ".tooltip";
        if (key.equals((comp = new TranslatableComponent(key)).getString())) {
            return null;
        }
        return this.f_96541_.f_91062_.m_92923_((FormattedText)comp, 170);
    }

    public CycleOption<Boolean> getBooleanOption(String translationKey, Supplier<Boolean> current, Consumer<Boolean> update) {
        return CycleOption.m_167758_((String)translationKey, (Component)new TranslatableComponent(translationKey + ".on"), (Component)new TranslatableComponent(translationKey + ".off"), options -> (Boolean)current.get(), (options, option, boolean_) -> update.accept((Boolean)boolean_)).m_167773_(mc -> this.createStaticTooltip(translationKey).apply((Minecraft)mc));
    }

    public CycleOption<Boolean> getOnOffOption(String translationKey, Supplier<Boolean> current, Consumer<Boolean> update) {
        return CycleOption.m_167743_((String)translationKey, options -> (Boolean)current.get(), (options, option, boolean_) -> update.accept((Boolean)boolean_)).m_167773_(mc -> this.createStaticTooltip(translationKey).apply((Minecraft)mc));
    }

    public ProgressOption getDoubleOption(String translationKey, float min, float max, float steps, Supplier<Double> current, Consumer<Double> update) {
        TranslatableComponent comp = new TranslatableComponent(translationKey);
        AtomicReference<ProgressOption> option = new AtomicReference<ProgressOption>();
        option.set(new ProgressOption(translationKey, (double)min, (double)max, steps, options -> (Double)current.get(), (options, val) -> {
            update.accept((Double)val);
            this.updateText((ProgressOption)option.get());
        }, (options, opt) -> comp.m_6881_().m_130946_(": " + CustomConfigScreen.round((Double)current.get(), 3)), mc -> this.getTooltip(translationKey)));
        return (ProgressOption)option.get();
    }

    public ProgressOption getIntOption(String translationKey, float min, float max, Supplier<Integer> current, Consumer<Integer> update) {
        TranslatableComponent comp = new TranslatableComponent(translationKey);
        AtomicReference<ProgressOption> option = new AtomicReference<ProgressOption>();
        option.set(new ProgressOption(translationKey, (double)min, (double)max, 1.0f, options -> (double)((Integer)current.get()), (options, val) -> {
            update.accept(val.intValue());
            this.updateText((ProgressOption)option.get());
        }, (options, opt) -> comp.m_6881_().m_130946_(": " + current.get()), mc -> this.getTooltip(translationKey)));
        return (ProgressOption)option.get();
    }

    public <T extends Enum> CycleOption getEnumOption(String translationKey, Class<T> targetEnum, Supplier<T> current, Consumer<T> update) {
        return CycleOption.m_167737_((String)translationKey, Arrays.asList((Enum[])targetEnum.getEnumConstants()), t -> new TranslatableComponent(translationKey + "." + t.name()), options -> (Enum)current.get(), (options, option, value) -> update.accept(value)).m_167773_(mc -> this.createStaticTooltip(translationKey).apply((Minecraft)mc));
    }

    public <T> Function<Minecraft, CycleButton.TooltipSupplier<T>> createStaticTooltip(final String translationKey) {
        return minecraft -> new CycleButton.TooltipSupplier<T>(){
            final /* synthetic */ Minecraft val$minecraft;
            {
                this.val$minecraft = minecraft;
            }

            public List<FormattedCharSequence> apply(T t) {
                TranslatableComponent comp;
                String key = translationKey + ".tooltip";
                if (key.equals((comp = new TranslatableComponent(key)).getString())) {
                    return null;
                }
                return this.val$minecraft.f_91062_.m_92923_((FormattedText)comp, 170);
            }
        };
    }

    public static List<FormattedCharSequence> tooltipAt(OptionsList optionsList, int i, int j) {
        if (!optionsList.m_5953_((double)i, (double)j)) {
            return ImmutableList.of();
        }
        Optional optional = optionsList.m_94480_((double)i, (double)j);
        return optional.isPresent() && optional.get() instanceof TooltipAccessor ? ((TooltipAccessor)optional.get()).m_141932_() : ImmutableList.of();
    }

    public static double round(double value, int places) {
        if (places < 0) {
            throw new IllegalArgumentException();
        }
        long factor = (long)Math.pow(10.0, places);
        long tmp = Math.round(value *= (double)factor);
        return (double)tmp / (double)factor;
    }

    public class PlainTextButton
    extends Button {
        private final Font font;
        private final Component message;
        private final Component underlinedMessage;

        public PlainTextButton(int i, int j, int k, int l, Component component, Button.OnPress onPress, Font font) {
            super(i, j, k, l, component, onPress);
            this.font = font;
            this.message = component;
            this.underlinedMessage = ComponentUtils.m_130750_((MutableComponent)component.m_6881_(), (Style)Style.f_131099_.m_131162_(Boolean.valueOf(true)));
        }

        public void m_6303_(PoseStack poseStack, int i, int j, float f) {
            Component component = this.m_198029_() ? this.underlinedMessage : this.message;
            PlainTextButton.m_93243_((PoseStack)poseStack, (Font)this.font, (Component)component, (int)this.f_93620_, (int)this.f_93621_, (int)(0xFFFFFF | Mth.m_14167_((float)(this.f_93625_ * 255.0f)) << 24));
        }
    }
}

