/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import dev.tr7zw.notenoughanimations.versionless.animations.BowAnimation;
import java.util.EnumSet;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;

public class CustomBowAnimation
extends BasicAnimation {
    private HumanoidModel.ArmPose rightArmPose;
    private HumanoidModel.ArmPose leftArmPose;
    private final EnumSet<HumanoidModel.ArmPose> twoHandedAnimatios = EnumSet.of(HumanoidModel.ArmPose.BOW_AND_ARROW);
    private final BodyPart[] parts = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM, BodyPart.BODY};

    @Override
    public boolean isEnabled() {
        return NEABaseMod.config.bowAnimation == BowAnimation.CUSTOM_V1;
    }

    @Override
    public boolean isValid(AbstractClientPlayer entity, PlayerData data) {
        this.rightArmPose = AnimationUtil.getArmPose(entity, entity.getMainArm() == HumanoidArm.LEFT ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        this.leftArmPose = AnimationUtil.getArmPose(entity, entity.getMainArm() == HumanoidArm.RIGHT ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND);
        return this.twoHandedAnimatios.contains(this.leftArmPose) || this.twoHandedAnimatios.contains(this.rightArmPose);
    }

    @Override
    public BodyPart[] getBodyParts(AbstractClientPlayer entity, PlayerData data) {
        return this.parts;
    }

    @Override
    public int getPriority(AbstractClientPlayer entity, PlayerData data) {
        return 3200;
    }

    @Override
    public void apply(AbstractClientPlayer entity, PlayerData data, PlayerModel<AbstractClientPlayer> model, BodyPart part, float delta, float tickCounter) {
        model.rightArm.yRot = Mth.clamp((float)(-0.1f + -model.head.xRot), (float)-1.25f, (float)0.5f);
        model.leftArm.yRot = Mth.clamp((float)(0.1f + -model.head.xRot), (float)-1.05f, (float)0.7f);
        model.rightArm.xRot = Mth.clamp((float)(-1.5707964f + model.head.yRot), (float)-2.0f, (float)0.0f);
        model.leftArm.xRot = Mth.clamp((float)(-1.5707964f + model.head.yRot + 0.8f), (float)-1.05f, (float)-0.65f);
        model.rightArm.zRot += 0.5f;
        model.leftArm.zRot += 0.5f;
    }
}

