/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.mixins;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.renderlayer.SwordRenderLayer;
import dev.tr7zw.notenoughanimations.versionless.animations.DataHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Player.class})
public class PlayerEntityMixin
implements PlayerData {
    private int armsUpdated = 0;
    private float[] lastRotations = new float[45];
    private ItemStack sideSword = ItemStack.EMPTY;
    private ItemStack[] lastHeldItems = new ItemStack[2];
    private boolean disableBodyRotation = false;
    private int itemSwapAnimationTimer = 0;
    private int lastAnimationSwapTick = -1;
    private Pose poseOverwrite = null;
    private Map<DataHolder<?>, Object> animationData = new HashMap();

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo info) {
        this.updateRenderLayerItems();
    }

    @Override
    public int isUpdated(int frameId) {
        return Math.abs(frameId - this.armsUpdated);
    }

    @Override
    public void setUpdated(int frameId) {
        this.armsUpdated = frameId;
    }

    @Override
    public float[] getLastRotations() {
        return this.lastRotations;
    }

    @Override
    public ItemStack getSideSword() {
        return this.sideSword;
    }

    @Override
    public void setSideSword(ItemStack item) {
        this.sideSword = item;
    }

    private void updateRenderLayerItems() {
        SwordRenderLayer.update((Player)this);
    }

    @Override
    public void disableBodyRotation(boolean val) {
        this.disableBodyRotation = val;
    }

    @Override
    public boolean isBodyRotationDisabled() {
        return this.disableBodyRotation;
    }

    @Override
    public ItemStack[] getLastHeldItems() {
        return this.lastHeldItems;
    }

    @Override
    public int getItemSwapAnimationTimer() {
        return this.itemSwapAnimationTimer;
    }

    @Override
    public void setItemSwapAnimationTimer(int count) {
        this.itemSwapAnimationTimer = count;
    }

    @Override
    public int getLastAnimationSwapTick() {
        return this.lastAnimationSwapTick;
    }

    @Override
    public void setLastAnimationSwapTick(int count) {
        this.lastAnimationSwapTick = count;
    }

    @Override
    public void setPoseOverwrite(Pose state) {
        this.poseOverwrite = state;
    }

    @Override
    public Pose getPoseOverwrite() {
        return this.poseOverwrite;
    }

    @Override
    public <T> T getData(DataHolder<T> holder, Supplier<T> builder) {
        return (T)this.animationData.computeIfAbsent(holder, h -> builder.get());
    }
}

