/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.fml;

import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.IncompatibleEnvironmentException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FakeOptiFineTransformationService
implements ITransformationService {
    private static final Logger LOGGER = LogManager.getLogger();
    private static FakeOptiFineTransformationService instance;
    public ITransformationService service;
    private String name;
    private IEnvironment env;
    private Set<String> otherServices;

    public FakeOptiFineTransformationService() {
        instance = this;
        try {
            this.service = (ITransformationService)Class.forName("optifine.OptiFineTransformationService").newInstance();
        }
        catch (Exception e) {
            LOGGER.error("It looks like you do not put real OptiFine to the mods folder. Scan libraries folder to find OptiFine later.", (Throwable)e);
        }
    }

    public static FakeOptiFineTransformationService getInstance() {
        if (instance == null) {
            return new FakeOptiFineTransformationService();
        }
        return instance;
    }

    @Nonnull
    public String name() {
        if (this.service != null && this.name == null) {
            this.name = "Fake" + this.service.name();
            this.service = null;
        }
        return this.name != null ? this.name : (this.name = "OptiFine");
    }

    public void initialize(@Nonnull IEnvironment environment) {
        if (this.service != null) {
            this.service.initialize(environment);
        }
    }

    public void beginScanning(@Nonnull IEnvironment environment) {
        if (this.service != null) {
            this.service.beginScanning(environment);
        }
    }

    public void onLoad(@Nonnull IEnvironment env, @Nonnull Set<String> otherServices) throws IncompatibleEnvironmentException {
        if (this.service != null) {
            this.service.onLoad(env, otherServices);
        } else {
            this.env = env;
            this.otherServices = otherServices;
        }
    }

    public Map.Entry<Set<String>, Supplier<Function<String, Optional<URL>>>> additionalResourcesLocator() {
        if (this.service != null) {
            return this.service.additionalResourcesLocator();
        }
        return super.additionalResourcesLocator();
    }

    public Map.Entry<Set<String>, Supplier<Function<String, Optional<URL>>>> additionalClassesLocator() {
        if (this.service != null) {
            return this.service.additionalClassesLocator();
        }
        return super.additionalClassesLocator();
    }

    @Nonnull
    public List<ITransformer> transformers() {
        if (this.service != null) {
            return this.service.transformers();
        }
        return new ArrayList<ITransformer>();
    }

    public IEnvironment getEnv() {
        return this.env;
    }

    public Set<String> getOtherServices() {
        return this.otherServices;
    }
}

