/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.fml;

import cpw.mods.modlauncher.Launcher;
import cpw.mods.modlauncher.ServiceLoaderStreamUtils;
import cpw.mods.modlauncher.TransformationServiceDecorator;
import cpw.mods.modlauncher.api.IEnvironment;
import cpw.mods.modlauncher.api.ITransformationService;
import cpw.mods.modlauncher.api.ITransformer;
import io.github.zekerzhayard.optiforge.asm.fml.FakeOptiFineTransformationService;
import io.github.zekerzhayard.optiforge.asm.fml.VersionChecker;
import java.lang.reflect.Constructor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraftforge.fml.loading.FMLServiceProvider;
import net.minecraftforge.fml.loading.ModDirTransformerDiscoverer;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OptiForgeWrapperTransformationService
implements ITransformationService {
    public static Boolean checked = null;
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String NAME = "optiforgewrapper";

    @Nonnull
    public String name() {
        return NAME;
    }

    public void initialize(@Nonnull IEnvironment environment) {
        StringBuilder currentFMLVersion = new StringBuilder();
        Object transformationServicesHandler = new Object();
        try {
            transformationServicesHandler = FieldUtils.readDeclaredField((Object)Launcher.INSTANCE, (String)"transformationServicesHandler", (boolean)true);
            ServiceLoader transformationServices = (ServiceLoader)FieldUtils.readDeclaredField((Object)transformationServicesHandler, (String)"transformationServices", (boolean)true);
            ServiceLoaderStreamUtils.map((ServiceLoader)transformationServices, ts -> ts).filter(ts -> ts.getClass().equals(FMLServiceProvider.class)).findFirst().ifPresent(ts -> {
                try {
                    currentFMLVersion.append(FieldUtils.readDeclaredField((Object)ts, (String)"targetForgeVersion", (boolean)true));
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }
        catch (Exception e) {
            LOGGER.error("An unexpected issue occurred when detecting Forge version, ignore this if you are under development environment: ", (Throwable)e);
        }
        try {
            Path path = Paths.get(OptiForgeWrapperTransformationService.class.getProtectionDomain().getCodeSource().getLocation().toURI());
            if (!Files.isDirectory(path, new LinkOption[0]) && currentFMLVersion.length() != 0) {
                checked = VersionChecker.IS_LOADED && VersionChecker.checkOptiFineVersion(VersionChecker.DEFAULT_FUNCTION, true) && VersionChecker.checkForgeVersion(VersionChecker.DEFAULT_FUNCTION, currentFMLVersion.toString());
                if (checked.booleanValue()) {
                    ModDirTransformerDiscoverer.getExtraLocators().add(path);
                } else {
                    Map serviceLookup = (Map)FieldUtils.readDeclaredField((Object)transformationServicesHandler, (String)"serviceLookup", (boolean)true);
                    if (serviceLookup.containsKey("OptiFine")) {
                        Constructor constructor = TransformationServiceDecorator.class.getDeclaredConstructor(ITransformationService.class);
                        constructor.setAccessible(true);
                        serviceLookup.put("OptiFine", constructor.newInstance(new FakeOptiFineTransformationService()));
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("An unexpected issue occurred when checking versions: ", (Throwable)e);
        }
    }

    public void beginScanning(@Nonnull IEnvironment environment) {
    }

    public void onLoad(@Nonnull IEnvironment env, @Nonnull Set<String> otherServices) {
    }

    @Nonnull
    public List<ITransformer> transformers() {
        return new ArrayList<ITransformer>();
    }

    static {
        try {
            FieldUtils.writeDeclaredField((Object)NAME, (String)"hash", (Object)-65536, (boolean)true);
        }
        catch (IllegalAccessException e) {
            LOGGER.error("", (Throwable)e);
        }
    }
}

