/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.transformers;

import com.google.common.collect.Sets;
import cpw.mods.modlauncher.api.ITransformer;
import cpw.mods.modlauncher.api.ITransformerVotingContext;
import cpw.mods.modlauncher.api.TransformerVoteResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.tree.ClassNode;

public interface ITransformerImpl
extends ITransformer<ClassNode> {
    public static final Logger LOGGER = LogManager.getLogger();

    public String targetClass();

    public ClassNode transform(ClassNode var1);

    @Nonnull
    default public ClassNode transform(@Nonnull ClassNode input, @Nonnull ITransformerVotingContext context) {
        LOGGER.info("Transform: " + input.name);
        input = this.transform(input);
        if (System.getProperty("optiforge.dumpclass", "false").equals("true")) {
            try {
                Path dumpPath = Paths.get("dumpclass", new String[0]);
                if (!Files.isDirectory(dumpPath, new LinkOption[0])) {
                    Files.createDirectories(dumpPath, new FileAttribute[0]);
                }
                ClassWriter cw = new ClassWriter(1);
                input.accept((ClassVisitor)cw);
                Path dumpclassPath = dumpPath.resolve(input.name + ".class");
                if (!Files.isDirectory(dumpclassPath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(dumpclassPath.getParent(), new FileAttribute[0]);
                }
                Files.write(dumpclassPath, cw.toByteArray(), new OpenOption[0]);
            }
            catch (Throwable t) {
                LOGGER.catching(t);
            }
        }
        return input;
    }

    @Nonnull
    default public TransformerVoteResult castVote(@Nonnull ITransformerVotingContext context) {
        return TransformerVoteResult.YES;
    }

    @Nonnull
    default public Set<ITransformer.Target> targets() {
        return Sets.newHashSet((Object[])new ITransformer.Target[]{ITransformer.Target.targetPreClass((String)this.targetClass())});
    }
}

