/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.transformers.net.minecraft.client.renderer;

import cpw.mods.modlauncher.api.ITransformer;
import io.github.zekerzhayard.optiforge.asm.transformers.ITransformerImpl;
import java.util.Objects;
import net.minecraftforge.coremod.api.ASMAPI;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.spongepowered.asm.util.Bytecode;

public class WorldRendererTransformer
implements ITransformer<ClassNode>,
ITransformerImpl {
    @Override
    public String targetClass() {
        return "net.minecraft.client.renderer.WorldRenderer";
    }

    @Override
    public ClassNode transform(ClassNode input) {
        MethodNode setupTerrain = Objects.requireNonNull(Bytecode.findMethod((ClassNode)input, (String)ASMAPI.mapMethod((String)"func_228437_a_"), (String)"(Lnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/culling/ClippingHelper;ZIZ)V"));
        for (AbstractInsnNode ain : setupTerrain.instructions.toArray()) {
            if (ain.getOpcode() != 182) continue;
            MethodInsnNode min = (MethodInsnNode)ain;
            if (!min.owner.equals("net/minecraft/client/renderer/chunk/ChunkRenderDispatcher$ChunkRender") || !min.name.equals(ASMAPI.mapMethod((String)"func_188281_o")) || !min.desc.equals("()Z")) continue;
            MethodInsnNode ain0 = min;
            while (!(ain0 instanceof LabelNode)) {
                ain0 = ain0.getNext();
            }
            LabelNode ln = (LabelNode)ain0;
            InsnList il = new InsnList();
            il.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraftforge/common/ForgeConfig", "CLIENT", "Lnet/minecraftforge/common/ForgeConfig$Client;"));
            il.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/common/ForgeConfig$Client", "alwaysSetupTerrainOffThread", "Lnet/minecraftforge/common/ForgeConfigSpec$BooleanValue;"));
            il.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/common/ForgeConfigSpec$BooleanValue", "get", "()Ljava/lang/Object;", false));
            il.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Boolean"));
            il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Boolean", "booleanValue", "()Z", false));
            il.add((AbstractInsnNode)new JumpInsnNode(154, ln));
            setupTerrain.instructions.insertBefore(min.getPrevious(), il);
            break;
        }
        MethodNode updateCameraAndRender = Objects.requireNonNull(Bytecode.findMethod((ClassNode)input, (String)ASMAPI.mapMethod((String)"func_228426_a_"), (String)"(Lcom/mojang/blaze3d/matrix/MatrixStack;FJZLnet/minecraft/client/renderer/ActiveRenderInfo;Lnet/minecraft/client/renderer/GameRenderer;Lnet/minecraft/client/renderer/LightTexture;Lnet/minecraft/util/math/vector/Matrix4f;)V"));
        int getModelManagerCount = 0;
        for (AbstractInsnNode ain : updateCameraAndRender.instructions.toArray()) {
            if (ain.getOpcode() != 182 && ain.getOpcode() != 183) continue;
            MethodInsnNode min = (MethodInsnNode)ain;
            if (min.owner.equals("net/minecraft/client/Minecraft") && min.name.equals(ASMAPI.mapMethod((String)"func_110434_K")) && min.desc.equals("()Lnet/minecraft/client/renderer/texture/TextureManager;")) {
                if (++getModelManagerCount <= 1) continue;
                min.name = ASMAPI.mapMethod((String)"func_209506_al");
                min.desc = "()Lnet/minecraft/client/renderer/model/ModelManager;";
                continue;
            }
            if (min.owner.equals("net/minecraft/client/renderer/texture/TextureManager") && min.name.equals(ASMAPI.mapMethod((String)"func_229267_b_")) && min.desc.equals("(Lnet/minecraft/util/ResourceLocation;)Lnet/minecraft/client/renderer/texture/Texture;")) {
                min.owner = "net/minecraft/client/renderer/model/ModelManager";
                min.name = ASMAPI.mapMethod((String)"func_229356_a_");
                min.desc = "(Lnet/minecraft/util/ResourceLocation;)Lnet/minecraft/client/renderer/texture/AtlasTexture;";
                continue;
            }
            if (!min.owner.equals("net/minecraft/client/renderer/texture/Texture") || !min.name.equals(ASMAPI.mapMethod((String)"func_174937_a")) || !min.desc.equals("(ZZ)V")) continue;
            min.owner = "net/minecraft/client/renderer/texture/AtlasTexture";
            min.name = "setBlurMipmap";
        }
        MethodNode updateChunks = Objects.requireNonNull(Bytecode.findMethod((ClassNode)input, (String)ASMAPI.mapMethod((String)"func_174967_a"), (String)"(J)V"));
        for (AbstractInsnNode ain : updateChunks.instructions.toArray()) {
            if (ain.getOpcode() != 182) continue;
            MethodInsnNode min = (MethodInsnNode)ain;
            if (!min.owner.equals("net/minecraft/client/renderer/chunk/ChunkRenderDispatcher$ChunkRender") || !min.name.equals(ASMAPI.mapMethod((String)"func_188281_o")) || !min.desc.equals("()Z")) continue;
            MethodInsnNode ain0 = min;
            while (ain0.getOpcode() != 153) {
                ain0 = ain0.getNext();
            }
            LabelNode ln = ((JumpInsnNode)ain0).label;
            InsnList il = new InsnList();
            il.add((AbstractInsnNode)new FieldInsnNode(178, "net/minecraftforge/common/ForgeConfig", "CLIENT", "Lnet/minecraftforge/common/ForgeConfig$Client;"));
            il.add((AbstractInsnNode)new FieldInsnNode(180, "net/minecraftforge/common/ForgeConfig$Client", "alwaysSetupTerrainOffThread", "Lnet/minecraftforge/common/ForgeConfigSpec$BooleanValue;"));
            il.add((AbstractInsnNode)new MethodInsnNode(182, "net/minecraftforge/common/ForgeConfigSpec$BooleanValue", "get", "()Ljava/lang/Object;", false));
            il.add((AbstractInsnNode)new TypeInsnNode(192, "java/lang/Boolean"));
            il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Boolean", "booleanValue", "()Z", false));
            il.add((AbstractInsnNode)new JumpInsnNode(154, ln));
            updateChunks.instructions.insertBefore(min.getPrevious(), il);
            break;
        }
        return input;
    }
}

