/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.transformers.net.minecraft.client.renderer.entity;

import cpw.mods.modlauncher.api.ITransformer;
import io.github.zekerzhayard.optiforge.asm.ModCompatibility;
import io.github.zekerzhayard.optiforge.asm.transformers.ITransformerImpl;
import java.util.Objects;
import net.minecraftforge.coremod.api.ASMAPI;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.util.Bytecode;

public class LivingRendererTransformer
implements ITransformer<ClassNode>,
ITransformerImpl {
    @Override
    public String targetClass() {
        return "net.minecraft.client.renderer.entity.LivingRenderer";
    }

    @Override
    public ClassNode transform(ClassNode input) {
        if (ModCompatibility.obfuscate()) {
            return input;
        }
        MethodNode render = Objects.requireNonNull(Bytecode.findMethod((ClassNode)input, (String)ASMAPI.mapMethod((String)"func_225623_a_"), (String)"(Lnet/minecraft/entity/LivingEntity;FFLcom/mojang/blaze3d/matrix/MatrixStack;Lnet/minecraft/client/renderer/IRenderTypeBuffer;I)V"));
        int maxIndex = 0;
        boolean isLongOrDouble = false;
        for (LocalVariableNode lvn : render.localVariables) {
            if (maxIndex >= lvn.index) continue;
            maxIndex = lvn.index;
            isLongOrDouble = lvn.desc.equals("J") || lvn.desc.equals("D");
        }
        maxIndex += isLongOrDouble ? 2 : 1;
        LabelNode start = null;
        LabelNode end = null;
        int isPassengerCount = 0;
        for (AbstractInsnNode ain : render.instructions.toArray()) {
            if (ain instanceof LabelNode) {
                if (start == null) {
                    start = (LabelNode)ain;
                    continue;
                }
                end = (LabelNode)ain;
                continue;
            }
            if (ain instanceof FieldInsnNode) {
                FieldInsnNode fin = (FieldInsnNode)ain;
                if (!fin.owner.equals("net/minecraft/client/renderer/entity/model/EntityModel") || !fin.name.equals(ASMAPI.mapField((String)"field_217113_d")) || !fin.desc.equals("Z")) continue;
                if (fin.getOpcode() == 181) {
                    render.instructions.insertBefore((AbstractInsnNode)fin, (AbstractInsnNode)new VarInsnNode(54, maxIndex));
                    render.instructions.insertBefore((AbstractInsnNode)fin, (AbstractInsnNode)new VarInsnNode(21, maxIndex));
                    continue;
                }
                if (fin.getOpcode() != 180) continue;
                AbstractInsnNode ain0 = fin.getPrevious();
                do {
                    render.instructions.remove(ain0.getNext());
                } while (!((ain0 = ain0.getPrevious()).getNext() instanceof VarInsnNode));
                render.instructions.remove(ain0.getNext());
                render.instructions.insert(ain0, (AbstractInsnNode)new VarInsnNode(21, maxIndex));
                continue;
            }
            if (ain.getOpcode() != 182) continue;
            MethodInsnNode min = (MethodInsnNode)ain;
            if (!min.owner.equals("net/minecraft/entity/LivingEntity") || !min.name.equals(ASMAPI.mapMethod((String)"func_184218_aH")) || !min.desc.equals("()Z") || ++isPassengerCount <= 2) continue;
            render.instructions.insert((AbstractInsnNode)min, (AbstractInsnNode)new VarInsnNode(21, maxIndex));
            render.instructions.remove(min.getPrevious());
            render.instructions.remove((AbstractInsnNode)min);
        }
        LocalVariableNode shouldSit = new LocalVariableNode("shouldSit", "Z", null, start, end, maxIndex);
        render.localVariables.add(shouldSit);
        return input;
    }
}

