/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.transformers.net.minecraft.client.renderer.model;

import cpw.mods.modlauncher.api.ITransformer;
import io.github.zekerzhayard.optiforge.asm.transformers.ITransformerImpl;
import io.github.zekerzhayard.optiforge.asm.utils.ASMUtils;
import java.util.Objects;
import net.minecraftforge.coremod.api.ASMAPI;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import org.spongepowered.asm.util.Bytecode;

public class ModelBakeryTransformer
implements ITransformer<ClassNode>,
ITransformerImpl {
    @Override
    public String targetClass() {
        return "net.minecraft.client.renderer.model.ModelBakery";
    }

    @Override
    public ClassNode transform(ClassNode input) {
        MethodNode getBakedModel = Objects.requireNonNull(Bytecode.findMethod((ClassNode)input, (String)"getBakedModel", (String)"(Lnet/minecraft/util/ResourceLocation;Lnet/minecraft/client/renderer/model/IModelTransform;Ljava/util/function/Function;)Lnet/minecraft/client/renderer/model/IBakedModel;"));
        AbstractInsnNode[] ains = getBakedModel.instructions.toArray();
        int ifeqCount = 0;
        LabelNode label_0 = new LabelNode();
        LabelNode label_1 = null;
        LabelNode label_2 = null;
        for (int i = ains.length - 1; i >= 0; --i) {
            AbstractInsnNode ain = ains[i];
            if (ain.getOpcode() == 153) {
                JumpInsnNode jin = (JumpInsnNode)ain;
                if (++ifeqCount != 1) continue;
                label_2 = jin.label;
                jin.label = label_0;
                continue;
            }
            if (label_1 == null && label_2 != null && ain instanceof LabelNode) {
                label_1 = (LabelNode)ain;
                getBakedModel.instructions.insertBefore(ain, (AbstractInsnNode)new JumpInsnNode(167, label_2));
                continue;
            }
            if (label_1 == null || label_2 == null || ain.getOpcode() != 25) continue;
            VarInsnNode vin = (VarInsnNode)ain;
            int iUnbakedModelIndex = ASMUtils.findLocalVariableIndex(getBakedModel, "Lnet/minecraft/client/renderer/model/IUnbakedModel;", 0);
            if (vin.var != iUnbakedModelIndex) continue;
            getBakedModel.instructions.insertBefore((AbstractInsnNode)vin, (AbstractInsnNode)new JumpInsnNode(167, label_1));
            getBakedModel.instructions.insertBefore((AbstractInsnNode)vin, (AbstractInsnNode)label_0);
            break;
        }
        MethodNode lambda$uploadTextures$12 = Objects.requireNonNull(Bytecode.findMethod((ClassNode)input, (String)"lambda$uploadTextures$12", (String)"(Lnet/minecraft/util/ResourceLocation;)V"));
        for (AbstractInsnNode ain : lambda$uploadTextures$12.instructions.toArray()) {
            if (ain.getOpcode() != 178) continue;
            FieldInsnNode fin = (FieldInsnNode)ain;
            if (!fin.owner.equals("net/minecraft/client/renderer/model/ModelBakery") || !fin.name.equals(ASMAPI.mapField((String)"field_177603_c")) || !fin.desc.equals("Lorg/apache/logging/log4j/Logger;")) continue;
            InsnList il = new InsnList();
            il.add((AbstractInsnNode)new VarInsnNode(25, ASMUtils.findLocalVariableIndex(lambda$uploadTextures$12, "Ljava/lang/Exception;", 0)));
            il.add((AbstractInsnNode)new MethodInsnNode(182, "java/lang/Exception", "printStackTrace", "()V", false));
            lambda$uploadTextures$12.instructions.insertBefore((AbstractInsnNode)fin, il);
            break;
        }
        return input;
    }
}

