/*
 * Decompiled with CFR 0.152.
 */
package io.github.zekerzhayard.optiforge.asm.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraftforge.coremod.api.ASMAPI;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.IincInsnNode;
import org.objectweb.asm.tree.JumpInsnNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public class ASMUtils {
    public static LocalVariableNode findLocalVariable(MethodNode mn, String desc, int ordinal) {
        ArrayList localVariables = Lists.newArrayList((Iterable)mn.localVariables);
        localVariables.sort(Comparator.comparingInt(o -> o.index));
        for (LocalVariableNode lvn : localVariables) {
            if (!lvn.desc.equals(desc)) continue;
            if (ordinal == 0) {
                return lvn;
            }
            --ordinal;
        }
        return null;
    }

    public static int findLocalVariableIndex(MethodNode mn, String desc, int ordinal) {
        LocalVariableNode lvn = ASMUtils.findLocalVariable(mn, desc, ordinal);
        return lvn == null ? -1 : lvn.index;
    }

    public static void insertLocalVariable(MethodNode mn, LocalVariableNode lvn, int index) {
        ASMUtils.insertLocalVariable(mn.localVariables, mn.instructions.toArray(), lvn, index);
    }

    public static void insertLocalVariable(List<LocalVariableNode> lvns, AbstractInsnNode[] ains, LocalVariableNode lvn, int index) {
        int shift = lvn.desc.equals("J") || lvn.desc.equals("D") ? 2 : 1;
        for (LocalVariableNode node : lvns) {
            if (node.index < lvn.index) continue;
            node.index += shift;
        }
        for (AbstractInsnNode ain : ains) {
            if (ain.getOpcode() >= 21 && ain.getOpcode() <= 25 || ain.getOpcode() >= 54 && ain.getOpcode() <= 58) {
                VarInsnNode vin = (VarInsnNode)ain;
                if (vin.var < lvn.index) continue;
                vin.var += shift;
                continue;
            }
            if (ain.getOpcode() != 132) continue;
            IincInsnNode iin = (IincInsnNode)ain;
            if (iin.var < lvn.index) continue;
            iin.var += shift;
        }
        lvns.add(index, lvn);
    }

    public static int getNextOfMaxLocalVariableIndex(List<LocalVariableNode> lvns) {
        LocalVariableNode maxIndexLvn = null;
        for (LocalVariableNode lvn : lvns) {
            if (maxIndexLvn != null && maxIndexLvn.index >= lvn.index) continue;
            maxIndexLvn = lvn;
        }
        return maxIndexLvn == null ? 0 : maxIndexLvn.index + (maxIndexLvn.desc.equals("J") || maxIndexLvn.desc.equals("D") ? 2 : 1);
    }

    public static void replaceInstance(MethodNode mn, String type, String fieldSrgName) {
        for (AbstractInsnNode ain : mn.instructions.toArray()) {
            if (ain.getOpcode() != 193 || !((TypeInsnNode)ain).desc.equals(type)) continue;
            ((JumpInsnNode)ain.getNext()).setOpcode(166);
            mn.instructions.set(ain, (AbstractInsnNode)new FieldInsnNode(178, "net/minecraft/item/Items", ASMAPI.mapField((String)fieldSrgName), "Lnet/minecraft/item/Item;"));
        }
    }
}

