/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.panorama.main;

import com.swdteam.panorama.main.Main;
import com.swdteam.panorama.main.Util;
import com.swdteam.panorama.main.registry.Keybinds;
import com.swdteam.panorama.ui.GuiPanoramaSelector;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.util.ScreenShotHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="panorama", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class Events {
    public static Map<String, NativeImage[]> images = new HashMap<String, NativeImage[]>();
    public static Vector3d position;
    static String currentName;
    static NativeImage[] screenshots;
    static boolean takePanorama;
    public static int index;
    public static double backupFov;

    @SubscribeEvent
    public static void screenshotEvent(TickEvent.ClientTickEvent event) {
        if (Minecraft.func_71410_x().field_71441_e != null && Minecraft.func_71410_x().field_175622_Z != null && Keybinds.SCREENSHOT.func_151468_f() && !takePanorama) {
            ClientPlayerEntity pe = Minecraft.func_71410_x().field_71439_g;
            position = new Vector3d(pe.func_226277_ct_(), pe.func_226278_cu_(), pe.func_226281_cx_());
            backupFov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
            Minecraft.func_71410_x().field_71474_y.field_74334_X = 90.0;
            currentName = "panorama-" + System.currentTimeMillis() / 100L;
            screenshots = new NativeImage[6];
            takePanorama = true;
            index = 0;
        }
    }

    public static void takeScreenshot(MainWindow window, int index) {
        int fromX;
        int dimension;
        NativeImage image = ScreenShotHelper.func_198052_a((int)window.func_198109_k(), (int)window.func_198091_l(), (Framebuffer)Minecraft.func_71410_x().func_147110_a());
        File file = new File("temp/panorama_" + index + ".png");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        int imageWidth = image.func_195702_a();
        int imageHeight = image.func_195714_b();
        int fromY = 0;
        if (imageWidth > imageHeight) {
            dimension = imageHeight;
            fromX = imageWidth / 2 - dimension / 2;
        } else {
            dimension = imageWidth;
            fromX = imageWidth / 2 - dimension / 2;
        }
        NativeImage image2 = new NativeImage(dimension, dimension, true);
        image.func_195708_a(fromX, fromY, dimension, dimension, image2);
        Events.screenshots[index] = image2;
    }

    @SubscribeEvent
    public static void cameraEvent(EntityViewRenderEvent.CameraSetup event) {
        if (takePanorama && index < 6) {
            Facing f = Facing.getIndex(index);
            event.setYaw(f.yaw);
            event.setPitch(f.pitch);
            event.setRoll(0.0f);
        }
    }

    @SubscribeEvent
    public static void fovEvent(EntityViewRenderEvent.FOVModifier event) {
        if (takePanorama) {
            event.setFOV(90.0);
        }
    }

    @SubscribeEvent
    public static void blockOverlayEvent(RenderBlockOverlayEvent event) {
        if (takePanorama) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void renderWorldEvent(RenderWorldLastEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (takePanorama) {
            if (index < 6) {
                mc.field_71474_y.field_74334_X = 90.0;
                MainWindow window = mc.func_228018_at_();
                Events.takeScreenshot(window, index);
                ++index;
            } else {
                takePanorama = false;
                mc.field_71474_y.field_74334_X = backupFov;
                images.put(currentName, screenshots);
                try {
                    Util.zipFiles(currentName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @SubscribeEvent
    public static void guiEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof MainMenuScreen) {
            MainMenuScreen gui = (MainMenuScreen)event.getGui();
            gui.field_209101_K = Main.SKYBOX;
        }
    }

    @SubscribeEvent
    public static void guiEvent(GuiScreenEvent.InitGuiEvent event) {
        if (event.getGui() instanceof MainMenuScreen) {
            MainMenuScreen gui = (MainMenuScreen)event.getGui();
            Button b = new Button(4, 4, 60, 20, (ITextComponent)new StringTextComponent("Panorama"), button -> Minecraft.func_71410_x().func_147108_a((Screen)new GuiPanoramaSelector()));
            gui.field_230705_e_.add(b);
            gui.field_230710_m_.add(b);
        }
    }

    static {
        currentName = "";
        takePanorama = false;
        index = 0;
        backupFov = 70.0;
    }

    public static enum Facing {
        SOUTH(0.0f, 0.0f),
        WEST(90.0f, 0.0f),
        NORTH(180.0f, 0.0f),
        EAST(-90.0f, 0.0f),
        UP(0.0f, -90.0f),
        DOWN(0.0f, 90.0f);

        float yaw;
        float pitch;

        private Facing(float yaw, float pitch) {
            this.yaw = yaw;
            this.pitch = pitch;
        }

        public static Facing getIndex(int index) {
            return Facing.values()[index];
        }
    }
}

