/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.panorama.main;

import com.swdteam.panorama.main.Events;
import com.swdteam.panorama.main.Skybox;
import com.swdteam.panorama.main.TextureUtil;
import com.swdteam.panorama.main.registry.PanoramaRegistry;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class Util {
    public static DynamicTexture test;

    public static void zipFiles(final String images) throws Exception {
        new Thread(new Runnable(){

            @Override
            public void run() {
                NativeImage[] imgs = Events.images.remove(images);
                String fileName = "panorama-" + System.currentTimeMillis() / 100L + ".zip";
                if (imgs != null) {
                    try {
                        FileOutputStream fos = new FileOutputStream("mods/panorama/" + fileName);
                        ZipOutputStream zos = new ZipOutputStream(fos);
                        for (int i = 0; i < imgs.length; ++i) {
                            NativeImage image = imgs[i];
                            zos.putNextEntry(new ZipEntry("panorama_" + i + ".png"));
                            zos.write(image.func_227796_e_());
                            zos.closeEntry();
                        }
                        zos.close();
                    }
                    catch (IOException ioe) {
                        System.out.println("Error creating zip file: " + ioe);
                    }
                }
                Minecraft.func_71410_x().field_71439_g.func_146105_b((ITextComponent)new StringTextComponent("Panorama saved as: " + images), false);
                PanoramaRegistry.addPanorama(fileName, new DynamicTexture(imgs[0]));
            }
        }).start();
    }

    public static void loadPack(String packName) throws Exception {
        DynamicTexture t;
        if (packName == null || packName != null && packName.length() <= 0) {
            Skybox.textures = null;
            return;
        }
        DynamicTexture[] textures = new DynamicTexture[6];
        DynamicTexture[] dynamicTextureArray = null;
        try (FileInputStream fis = new FileInputStream("mods/panorama/" + packName);
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream zis = new ZipInputStream(bis);){
            ZipEntry ze;
            int index = 0;
            while ((ze = zis.getNextEntry()) != null) {
                if (!ze.getName().endsWith(".png")) continue;
                textures[index] = TextureUtil.loadInputstream(zis);
                if (++index != 6) continue;
            }
            zis.close();
            bis.close();
            zis.close();
        }
        catch (Throwable object) {
            dynamicTextureArray = object;
            throw object;
        }
        boolean cont = true;
        dynamicTextureArray = textures;
        int n = dynamicTextureArray.length;
        int n2 = 0;
        if (n2 < n && (t = dynamicTextureArray[n2]) == null) {
            cont = false;
        }
        if (cont) {
            Skybox.textures = textures;
            FileWriter fw = new FileWriter(new File("panorama.dat"));
            fw.write(packName);
            fw.close();
        }
    }

    public static void loadPackIcon(String packName) throws Exception {
        DynamicTexture texture = null;
        try (FileInputStream fis = new FileInputStream("mods/panorama/" + packName);
             BufferedInputStream bis = new BufferedInputStream(fis);
             ZipInputStream zis = new ZipInputStream(bis);){
            ZipEntry ze;
            while ((ze = zis.getNextEntry()) != null) {
                if (ze.getName().equals("icon.png")) {
                    texture = TextureUtil.loadInputstream(zis);
                    break;
                }
                if (!ze.getName().equalsIgnoreCase("panorama_0.png")) continue;
                texture = TextureUtil.loadInputstream(zis);
            }
            zis.close();
            bis.close();
            zis.close();
        }
        if (texture != null) {
            PanoramaRegistry.addPanorama(packName, texture);
        }
    }
}

