/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.panorama.ui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.swdteam.panorama.main.Main;
import com.swdteam.panorama.main.Util;
import com.swdteam.panorama.main.registry.Panorama;
import com.swdteam.panorama.main.registry.PanoramaRegistry;
import com.swdteam.panorama.ui.PanoramaButton;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.MainMenuScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class GuiPanoramaSelector
extends Screen {
    private TextFieldWidget searchBox;
    private List<Panorama> panoramas = new ArrayList<Panorama>();
    private List<PanoramaButton> panoButtons = new ArrayList<PanoramaButton>();
    private Button btnPreviousPage;
    private Button btnNextPage;
    private int page = 0;
    private ITextComponent tooltip;

    public GuiPanoramaSelector() {
        super((ITextComponent)new StringTextComponent("Panorama Selection GUI"));
        this.panoramas = PanoramaRegistry.PANORAMAS;
    }

    public void func_231158_b_(Minecraft minecraft, int width, int height) {
        super.func_231158_b_(minecraft, width, height);
        this.page = 0;
        this.searchBox = new TextFieldWidget(this.field_230706_i_.field_71466_p, this.field_230708_k_ / 2 - 148, height / 2 + 80, 70, 20, (TextFieldWidget)null, (ITextComponent)new TranslationTextComponent("panorama.search"));
        this.func_230481_d_((IGuiEventListener)this.searchBox);
        this.func_212928_a((IGuiEventListener)this.searchBox);
        this.func_230480_a_((Widget)new Button(width / 2 - 72, height / 2 + 80, 46, 20, (ITextComponent)new StringTextComponent("Search"), button -> {
            if (this.searchBox.func_146179_b() != null && this.searchBox.func_146179_b().length() > 0) {
                this.page = 0;
                this.panoramas = PanoramaRegistry.getAllForName(this.searchBox.func_146179_b());
                this.btnNextPage.field_230693_o_ = this.panoramas.size() > 8;
                this.refreshButtons();
            }
        }));
        this.btnPreviousPage = new Button(width / 2 - 22, height / 2 + 80, 80, 20, (ITextComponent)new StringTextComponent("Previous Page"), button -> {
            if (this.page - 1 >= 0) {
                --this.page;
                this.btnNextPage.field_230693_o_ = true;
                this.refreshButtons();
                if (this.page - 1 < 0) {
                    this.btnPreviousPage.field_230693_o_ = false;
                }
            }
        });
        this.func_230480_a_((Widget)this.btnPreviousPage);
        this.btnPreviousPage.field_230693_o_ = false;
        this.btnNextPage = new Button(width / 2 + 62, height / 2 + 80, 80, 20, (ITextComponent)new StringTextComponent("Next Page"), button -> {
            System.out.println(this.panoramas.size());
            if ((this.page + 1) * 8 < this.panoramas.size()) {
                ++this.page;
                this.btnPreviousPage.field_230693_o_ = true;
                this.refreshButtons();
                if ((this.page + 1) * 8 >= this.panoramas.size()) {
                    this.btnNextPage.field_230693_o_ = false;
                }
            }
        });
        this.func_230480_a_((Widget)this.btnNextPage);
        this.func_230480_a_((Widget)new Button(4, 4, 60, 20, (ITextComponent)new StringTextComponent("Back"), button -> Minecraft.func_71410_x().func_147108_a((Screen)new MainMenuScreen())));
        this.func_230480_a_((Widget)new Button(width - 64, 4, 60, 20, (ITextComponent)new StringTextComponent("Reload"), button -> {
            this.page = 0;
            PanoramaRegistry.setup();
            this.panoramas = PanoramaRegistry.PANORAMAS;
            this.btnNextPage.field_230693_o_ = this.panoramas.size() > 8;
            this.refreshButtons();
        }));
        this.func_230480_a_((Widget)new Button(width - 128, 4, 60, 20, (ITextComponent)new StringTextComponent("Reset"), button -> {
            try {
                Util.loadPack("");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }));
        if (this.panoramas.size() <= 8) {
            this.btnNextPage.field_230693_o_ = false;
        }
        this.refreshButtons();
    }

    public void refreshButtons() {
        this.field_230705_e_.removeAll(this.panoButtons);
        this.field_230710_m_.removeAll(this.panoButtons);
        for (int i = this.page * 8; i < this.page * 8 + 8; ++i) {
            if (i >= this.panoramas.size()) continue;
            Panorama pan = this.panoramas.get(i);
            this.addPanoramaButton(new PanoramaButton(pan, this.field_230708_k_ / 2 - 148 + i % 4 * 74, this.field_230709_l_ / 2 + i % 8 / 4 * 74 - 74));
        }
    }

    public void addPanoramaButton(PanoramaButton btn) {
        this.func_230480_a_((Widget)btn);
        this.panoButtons.add(btn);
    }

    public void func_230430_a_(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        Main.SKYBOX.func_217623_a(partialTicks, MathHelper.func_76131_a((float)1.0f, (float)0.0f, (float)1.0f));
        GuiPanoramaSelector.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"Panorama Selector", (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2 - 102), (int)-1);
        if (this.panoramas.size() <= 0) {
            GuiPanoramaSelector.func_238471_a_((MatrixStack)matrixStack, (FontRenderer)this.field_230712_o_, (String)"No Panoramas Found", (int)(this.field_230708_k_ / 2), (int)(this.field_230709_l_ / 2), (int)-1);
        }
        if (this.searchBox != null) {
            this.searchBox.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        }
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.tooltip = null;
        for (int i = 0; i < this.field_230710_m_.size(); ++i) {
            PanoramaButton bb;
            Widget b = (Widget)this.field_230710_m_.get(i);
            if (!(b instanceof PanoramaButton) || !(bb = (PanoramaButton)b).func_230449_g_()) continue;
            this.tooltip = bb.func_230458_i_();
        }
        if (this.tooltip != null) {
            this.func_238652_a_(matrixStack, this.tooltip, mouseX, mouseY);
        }
    }

    public void func_231023_e_() {
        if (this.searchBox != null) {
            this.searchBox.func_146178_a();
        }
        super.func_231023_e_();
    }
}

