/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.panorama.main;

import com.mojang.blaze3d.platform.NativeImage;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.DynamicTexture;
import org.lwjgl.system.MemoryUtil;

public class TextureUtil {
    public static DynamicTexture loadInputstream(InputStream stream) throws Exception {
        NativeImage im = TextureUtil.read(stream);
        return new DynamicTexture(im);
    }

    public static NativeImage read(InputStream inputStreamIn) throws IOException {
        return TextureUtil.read(NativeImage.Format.RGBA, inputStreamIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NativeImage read(@Nullable NativeImage.Format pixelFormatIn, InputStream inputStreamIn) throws IOException {
        NativeImage nativeimage;
        ByteBuffer bytebuffer = null;
        try {
            bytebuffer = TextureUtil.readToBuffer(inputStreamIn);
            ((Buffer)bytebuffer).rewind();
            nativeimage = NativeImage.m_85051_((NativeImage.Format)pixelFormatIn, (ByteBuffer)bytebuffer);
        }
        finally {
            MemoryUtil.memFree((Buffer)bytebuffer);
        }
        return nativeimage;
    }

    public static ByteBuffer readToBuffer(InputStream inputStreamIn) throws IOException {
        ByteBuffer bytebuffer;
        if (inputStreamIn instanceof FileInputStream) {
            FileInputStream fileinputstream = (FileInputStream)inputStreamIn;
            FileChannel filechannel = fileinputstream.getChannel();
            bytebuffer = MemoryUtil.memAlloc((int)((int)filechannel.size() + 1));
            while (filechannel.read(bytebuffer) != -1) {
            }
        } else {
            bytebuffer = MemoryUtil.memAlloc((int)8192);
            ReadableByteChannel readablebytechannel = Channels.newChannel(inputStreamIn);
            while (readablebytechannel.read(bytebuffer) != -1) {
                if (bytebuffer.remaining() != 0) continue;
                bytebuffer = MemoryUtil.memRealloc((ByteBuffer)bytebuffer, (int)(bytebuffer.capacity() * 2));
            }
        }
        return bytebuffer;
    }
}

