/*
 * Decompiled with CFR 0.152.
 */
package com.swdteam.panorama;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.swdteam.panorama.Panorama;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;

public class Config {
    private static Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static Config INSTANCE;
    public Panorama.CaptureResolution save_resolution = Panorama.CaptureResolution.DEFAULT;
    public String save_directory = "mods/panorama/";

    public static void load() {
        File file = new File("config/panorama.json");
        if (!file.exists()) {
            Config.generate();
        }
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            StringBuilder sb = new StringBuilder();
            String s = null;
            while ((s = reader.readLine()) != null) {
                sb.append(s);
            }
            reader.close();
            INSTANCE = (Config)GSON.fromJson(sb.toString(), Config.class);
        }
        catch (Exception e) {
            INSTANCE = new Config();
        }
        File f = new File(Config.INSTANCE.save_directory);
        if (!f.exists()) {
            f.mkdirs();
        }
    }

    private static void generate() {
        File file = new File("config/panorama.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        INSTANCE = new Config();
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(GSON.toJson((Object)INSTANCE));
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void save() {
        File file = new File("config/panorama.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdirs();
        }
        try {
            FileWriter writer = new FileWriter(file);
            writer.write(GSON.toJson((Object)INSTANCE));
            writer.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

